/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.step.StepReporter;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import io.reactivex.Maybe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Launch {
    private static final ThreadLocal<Launch> CURRENT_LAUNCH = new InheritableThreadLocal<Launch>();
    static final Logger LOGGER = LoggerFactory.getLogger(Launch.class);
    private final ListenerParameters parameters;
    private final StepReporter stepReporter;
    public static final Launch NOOP_LAUNCH = new Launch(new ListenerParameters()){

        @Override
        public Maybe<String> start() {
            return Maybe.empty();
        }

        @Override
        public void finish(FinishExecutionRQ rq) {
        }

        @Override
        public Maybe<String> startTestItem(StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        public Maybe<String> startTestItem(Maybe<String> parentId, StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        public Maybe<String> startTestItem(Maybe<String> parentId, Maybe<String> retryOf, StartTestItemRQ rq) {
            return Maybe.empty();
        }

        @Override
        public Maybe<OperationCompletionRS> finishTestItem(Maybe<String> itemId, FinishTestItemRQ rq) {
            return Maybe.empty();
        }
    };

    Launch(ListenerParameters parameters) {
        this.parameters = parameters;
        this.stepReporter = new StepReporter(this);
        CURRENT_LAUNCH.set(this);
    }

    public abstract Maybe<String> start();

    public abstract void finish(FinishExecutionRQ var1);

    public abstract Maybe<String> startTestItem(StartTestItemRQ var1);

    public abstract Maybe<String> startTestItem(Maybe<String> var1, StartTestItemRQ var2);

    public abstract Maybe<String> startTestItem(Maybe<String> var1, Maybe<String> var2, StartTestItemRQ var3);

    public abstract Maybe<OperationCompletionRS> finishTestItem(Maybe<String> var1, FinishTestItemRQ var2);

    public ListenerParameters getParameters() {
        CURRENT_LAUNCH.set(this);
        return this.parameters;
    }

    public static Launch currentLaunch() {
        return CURRENT_LAUNCH.get();
    }

    public StepReporter getStepReporter() {
        return this.stepReporter;
    }
}

