/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.service.Launch;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import io.reactivex.functions.Consumer;

final class LoggingCallback {
    static final Consumer<OperationCompletionRS> LOG_SUCCESS = new Consumer<OperationCompletionRS>(){

        public void accept(OperationCompletionRS rs) {
            Launch.LOGGER.debug(rs.getResultMessage());
        }
    };
    static final Consumer<Throwable> LOG_ERROR = new Consumer<Throwable>(){

        public void accept(Throwable rs) {
            Launch.LOGGER.error("[{}] ReportPortal execution error", (Object)Thread.currentThread().getId(), (Object)rs);
        }
    };

    private LoggingCallback() {
    }

    static Consumer<EntryCreatedAsyncRS> logCreated(final String entry) {
        return new Consumer<EntryCreatedAsyncRS>(){

            public void accept(EntryCreatedAsyncRS rs) {
                Launch.LOGGER.debug("ReportPortal {} with ID '{}' has been created", (Object)entry, (Object)rs.getId());
            }
        };
    }
}

