/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.analytics.item;

import com.epam.reportportal.service.analytics.item.AnalyticsItem;
import io.reactivex.annotations.Nullable;
import java.util.Map;
import rp.com.google.common.collect.Maps;

public class AnalyticsEvent
implements AnalyticsItem {
    private static final String TYPE = "event";
    private final Map<String, String> params;

    public AnalyticsEvent(@Nullable String eventCategory, @Nullable String eventAction, @Nullable String eventLabel) {
        this.params = Maps.newHashMapWithExpectedSize(4);
        this.params.put("t", TYPE);
        this.params.put("ec", eventCategory);
        this.params.put("ea", eventAction);
        this.params.put("el", eventLabel);
    }

    private AnalyticsEvent(Map<String, String> params) {
        this.params = params;
    }

    public static AnalyticsEventBuilder builder() {
        return new AnalyticsEventBuilder();
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    public static class AnalyticsEventBuilder {
        private Map<String, String> params = Maps.newHashMapWithExpectedSize(4);

        public AnalyticsEventBuilder() {
            this.params.put("t", AnalyticsEvent.TYPE);
        }

        public AnalyticsEventBuilder withCategory(String category) {
            this.params.put("ec", category);
            return this;
        }

        public AnalyticsEventBuilder withAction(String action) {
            this.params.put("ea", action);
            return this;
        }

        public AnalyticsEventBuilder withLabel(String label) {
            this.params.put("el", label);
            return this;
        }

        public AnalyticsEvent build() {
            return new AnalyticsEvent(this.params);
        }
    }
}

