/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.tree;

import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import io.reactivex.Maybe;
import io.reactivex.annotations.Nullable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TestItemTree {
    private Maybe<String> launchId;
    private final Map<ItemTreeKey, TestItemLeaf> testItems = new ConcurrentHashMap<ItemTreeKey, TestItemLeaf>();

    public static TestItemLeaf createTestItemLeaf(Maybe<String> itemId, int expectedChildrenCount) {
        return new TestItemLeaf(itemId, expectedChildrenCount);
    }

    public static TestItemLeaf createTestItemLeaf(Maybe<String> parentId, Maybe<String> itemId, int expectedChildrenCount) {
        return new TestItemLeaf(parentId, itemId, expectedChildrenCount);
    }

    public static TestItemLeaf createTestItemLeaf(Maybe<String> itemId, ConcurrentHashMap<ItemTreeKey, TestItemLeaf> childItems) {
        return new TestItemLeaf(itemId, childItems);
    }

    public static TestItemLeaf createTestItemLeaf(Maybe<String> parentId, Maybe<String> itemId, ConcurrentHashMap<ItemTreeKey, TestItemLeaf> childItems) {
        return new TestItemLeaf(parentId, itemId, childItems);
    }

    public Maybe<String> getLaunchId() {
        return this.launchId;
    }

    public void setLaunchId(Maybe<String> launchId) {
        this.launchId = launchId;
    }

    public Map<ItemTreeKey, TestItemLeaf> getTestItems() {
        return this.testItems;
    }

    public static class TestItemLeaf {
        @Nullable
        private Maybe<String> parentId;
        @Nullable
        private Maybe<OperationCompletionRS> finishResponse;
        private final Maybe<String> itemId;
        private final Map<ItemTreeKey, TestItemLeaf> childItems;

        private TestItemLeaf(Maybe<String> itemId, int expectedChildrenCount) {
            this.itemId = itemId;
            this.childItems = new ConcurrentHashMap<ItemTreeKey, TestItemLeaf>(expectedChildrenCount);
        }

        private TestItemLeaf(Maybe<String> itemId, ConcurrentHashMap<ItemTreeKey, TestItemLeaf> childItems) {
            this.itemId = itemId;
            this.childItems = childItems;
        }

        private TestItemLeaf(@Nullable Maybe<String> parentId, Maybe<String> itemId, int expectedChildrenCount) {
            this(itemId, expectedChildrenCount);
            this.parentId = parentId;
        }

        private TestItemLeaf(@Nullable Maybe<String> parentId, Maybe<String> itemId, ConcurrentHashMap<ItemTreeKey, TestItemLeaf> childItems) {
            this(itemId, childItems);
            this.parentId = parentId;
        }

        @Nullable
        public Maybe<String> getParentId() {
            return this.parentId;
        }

        public void setParentId(@Nullable Maybe<String> parentId) {
            this.parentId = parentId;
        }

        @Nullable
        public Maybe<OperationCompletionRS> getFinishResponse() {
            return this.finishResponse;
        }

        public void setFinishResponse(@Nullable Maybe<OperationCompletionRS> finishResponse) {
            this.finishResponse = finishResponse;
        }

        public Maybe<String> getItemId() {
            return this.itemId;
        }

        public Map<ItemTreeKey, TestItemLeaf> getChildItems() {
            return this.childItems;
        }
    }

    public static final class ItemTreeKey {
        private final String name;
        private final int hash;

        private ItemTreeKey(String name) {
            this.name = name;
            this.hash = name != null ? name.hashCode() : 0;
        }

        private ItemTreeKey(String name, int hash) {
            this.name = name;
            this.hash = hash;
        }

        public String getName() {
            return this.name;
        }

        public int getHash() {
            return this.hash;
        }

        public static ItemTreeKey of(String name) {
            return new ItemTreeKey(name);
        }

        public static ItemTreeKey of(String name, int hash) {
            return new ItemTreeKey(name, hash);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemTreeKey that = (ItemTreeKey)o;
            if (this.hash != that.hash) {
                return false;
            }
            return this.name != null ? this.name.equals(that.name) : that.name == null;
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.hash;
            return result;
        }
    }
}

