/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.annotations.TestCaseIdKey;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import io.reactivex.annotations.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class TestCaseIdUtils {
    private TestCaseIdUtils() {
    }

    @Nullable
    public static TestCaseIdEntry getParameterizedTestCaseId(Method method, Object ... parameters) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int paramIndex = 0; paramIndex < parameterAnnotations.length; ++paramIndex) {
            for (int annotationIndex = 0; annotationIndex < parameterAnnotations[paramIndex].length; ++annotationIndex) {
                Annotation testCaseIdAnnotation = parameterAnnotations[paramIndex][annotationIndex];
                if (testCaseIdAnnotation.annotationType() != TestCaseIdKey.class) continue;
                return TestCaseIdUtils.getTestCaseId((TestCaseIdKey)testCaseIdAnnotation, paramIndex, parameters);
            }
        }
        return null;
    }

    @Nullable
    private static TestCaseIdEntry getTestCaseId(TestCaseIdKey testCaseIdKey, int paramIndex, Object ... parameters) {
        Object testCaseIdParam = parameters[paramIndex];
        if (testCaseIdParam != null) {
            return new TestCaseIdEntry(String.valueOf(testCaseIdParam));
        }
        return null;
    }
}

