/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Waiter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Waiter.class);
    private static final ThreadLocal<Random> RANDOM = new ThreadLocal<Random>(){

        @Override
        protected Random initialValue() {
            return new Random();
        }
    };
    private final String waitDescription;
    private long durationNs = TimeUnit.MINUTES.toNanos(1L);
    private long pollingNs = TimeUnit.MILLISECONDS.toNanos(100L);
    private List<Class<? extends Throwable>> ignoreExceptions = new ArrayList<Class<? extends Throwable>>();
    private boolean useDiscrepancy = false;
    private float discrepancy = 0.0f;
    private double maxDiscrepancyNs = (float)this.pollingNs * this.discrepancy;
    private boolean failOnTimeout = false;

    public Waiter(String description) {
        this.waitDescription = description;
    }

    public Waiter duration(long duration, TimeUnit timeUnit) {
        assert (duration >= 0L);
        this.durationNs = timeUnit.toNanos(duration);
        return this;
    }

    public Waiter pollingEvery(long duration, TimeUnit timeUnit) {
        assert (duration > 0L);
        this.pollingNs = timeUnit.toNanos(duration);
        return this.useDiscrepancy ? this.applyRandomDiscrepancy(this.discrepancy) : this;
    }

    public Waiter ignore(Class<? extends Throwable> exception) {
        assert (exception != null);
        this.ignoreExceptions.add(exception);
        return this;
    }

    public Waiter applyRandomDiscrepancy(float maximumDiscrepancy) {
        assert (maximumDiscrepancy <= 1.0f && maximumDiscrepancy >= 0.0f);
        this.discrepancy = maximumDiscrepancy;
        this.useDiscrepancy = maximumDiscrepancy > 0.0f;
        this.maxDiscrepancyNs = (float)this.pollingNs * this.discrepancy;
        return this;
    }

    public Waiter timeoutFail() {
        this.failOnTimeout = true;
        return this;
    }

    private long getDiscrepancy() {
        if (!this.useDiscrepancy) {
            return 0L;
        }
        Random random = RANDOM.get();
        double absoluteDiscrepancy = this.maxDiscrepancyNs * random.nextDouble();
        double discrepancy = random.nextBoolean() ? absoluteDiscrepancy : -absoluteDiscrepancy;
        return (long)discrepancy;
    }

    private boolean knownException(Exception e) {
        for (Class<? extends Throwable> known : this.ignoreExceptions) {
            if (!known.isAssignableFrom(e.getClass())) continue;
            return true;
        }
        return false;
    }

    public <T> T till(Callable<T> waitFor) {
        long triesLong = this.durationNs / this.pollingNs;
        int tries = triesLong > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)triesLong;
        CountDownLatch countDown = new CountDownLatch(tries);
        try {
            do {
                try {
                    T result = waitFor.call();
                    if (result != null) {
                        return result;
                    }
                }
                catch (Exception e) {
                    if (!this.knownException(e)) {
                        LOGGER.error("An exception caught while waiting for a result: " + e.getLocalizedMessage(), (Throwable)e);
                        throw new InternalReportPortalClientException(e.getLocalizedMessage(), e);
                    }
                    LOGGER.trace("A known exception caught while waiting for a result: " + e.getLocalizedMessage(), (Throwable)e);
                }
                countDown.countDown();
            } while (!countDown.await(this.pollingNs + this.getDiscrepancy(), TimeUnit.NANOSECONDS));
            if (this.failOnTimeout) {
                throw new InternalReportPortalClientException(this.waitDescription + " timed out");
            }
        }
        catch (InterruptedException ignored) {
            LOGGER.warn(this.waitDescription + " was interrupted");
        }
        return null;
    }
}

