/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.aspect;

import com.epam.reportportal.annotations.Step;
import com.epam.reportportal.annotations.UniqueID;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.reportportal.aspect.StepNameUtils;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.utils.AttributeParser;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

class StepRequestUtils {
    private StepRequestUtils() {
    }

    static StartTestItemRQ buildStartStepRequest(MethodSignature signature, Step step, JoinPoint joinPoint) {
        UniqueID uniqueIdAnnotation = signature.getMethod().getAnnotation(UniqueID.class);
        String uniqueId = uniqueIdAnnotation != null ? uniqueIdAnnotation.value() : null;
        String name = StepNameUtils.getStepName(step, signature, joinPoint);
        StartTestItemRQ request = new StartTestItemRQ();
        if (uniqueId != null && !uniqueId.trim().isEmpty()) {
            request.setUniqueId(uniqueId);
        }
        request.setAttributes(StepRequestUtils.createStepAttributes(signature));
        if (!step.description().isEmpty()) {
            request.setDescription(step.description());
        }
        request.setName(name);
        request.setStartTime(Calendar.getInstance().getTime());
        request.setType("STEP");
        request.setHasStats(false);
        return request;
    }

    static FinishTestItemRQ buildFinishStepRequest(ItemStatus status, Date endTime) {
        FinishTestItemRQ rq = new FinishTestItemRQ();
        rq.setEndTime(endTime);
        rq.setStatus(status.name());
        return rq;
    }

    private static Set<ItemAttributesRQ> createStepAttributes(MethodSignature methodSignature) {
        Attributes attributesAnnotation = methodSignature.getMethod().getAnnotation(Attributes.class);
        if (attributesAnnotation != null) {
            return AttributeParser.retrieveAttributes(attributesAnnotation);
        }
        return null;
    }
}

