/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.exception.ReportPortalException;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.LaunchLoggingContext;
import com.epam.reportportal.service.LoggingCallback;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.utils.RetryWithDelay;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.item.ItemCreatedRS;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.MaybeEmitter;
import io.reactivex.MaybeOnSubscribe;
import io.reactivex.MaybeSource;
import io.reactivex.Scheduler;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import rp.com.google.common.cache.CacheBuilder;
import rp.com.google.common.cache.CacheLoader;
import rp.com.google.common.cache.LoadingCache;
import rp.com.google.common.collect.Lists;

public class LaunchImpl
extends Launch {
    private static final Map<ExecutorService, Scheduler> SCHEDULERS = new ConcurrentHashMap<ExecutorService, Scheduler>();
    private static final Function<ItemCreatedRS, String> TO_ID = EntryCreatedAsyncRS::getId;
    private static final Consumer<StartLaunchRS> LAUNCH_SUCCESS_CONSUMER = rs -> {
        LoggingCallback.logCreated("launch").accept(rs);
        System.setProperty("rp.launch.id", String.valueOf(rs.getId()));
    };
    private static final int DEFAULT_RETRY_COUNT = 5;
    private static final int DEFAULT_RETRY_TIMEOUT = 2;
    private static final int ITEM_FINISH_MAX_RETRIES = 10;
    private static final int ITEM_FINISH_RETRY_TIMEOUT = 10;
    private static final Predicate<Throwable> INTERNAL_CLIENT_EXCEPTION_PREDICATE = throwable -> throwable instanceof InternalReportPortalClientException;
    private static final Predicate<Throwable> TEST_ITEM_FINISH_RETRY_PREDICATE = throwable -> throwable instanceof ReportPortalException && ErrorType.FINISH_ITEM_NOT_ALLOWED.equals((Object)((ReportPortalException)throwable).getError().getErrorType()) || INTERNAL_CLIENT_EXCEPTION_PREDICATE.test(throwable);
    private static final RetryWithDelay DEFAULT_REQUEST_RETRY = new RetryWithDelay(INTERNAL_CLIENT_EXCEPTION_PREDICATE, 5L, TimeUnit.SECONDS.toMillis(2L));
    private static final RetryWithDelay TEST_ITEM_FINISH_REQUEST_RETRY = new RetryWithDelay(TEST_ITEM_FINISH_RETRY_PREDICATE, 10L, TimeUnit.SECONDS.toMillis(10L));
    public static final String NOT_ISSUE = "NOT_ISSUE";
    private final ReportPortalClient rpClient;
    protected final LoadingCache<Maybe<String>, TreeItem> QUEUE = CacheBuilder.newBuilder().build(new CacheLoader<Maybe<String>, TreeItem>(){

        @Override
        public TreeItem load(Maybe<String> key) {
            return new TreeItem();
        }
    });
    protected final Maybe<String> launch;
    private final ExecutorService executor;
    private final Scheduler scheduler;

    protected LaunchImpl(@NotNull ReportPortalClient reportPortalClient, @NotNull ListenerParameters parameters, final @NotNull StartLaunchRQ rq, @NotNull ExecutorService executorService) {
        super(parameters);
        this.rpClient = Objects.requireNonNull(reportPortalClient, "RestEndpoint shouldn't be NULL");
        Objects.requireNonNull(parameters, "Parameters shouldn't be NULL");
        this.executor = Objects.requireNonNull(executorService);
        this.scheduler = this.createScheduler(this.executor);
        LOGGER.info("Rerun: {}", (Object)parameters.isRerun());
        this.launch = Maybe.create((MaybeOnSubscribe)new MaybeOnSubscribe<String>(){

            public void subscribe(final MaybeEmitter<String> emitter) {
                Maybe launchPromise = Maybe.defer((Callable)new Callable<MaybeSource<? extends StartLaunchRS>>(){

                    @Override
                    public MaybeSource<? extends StartLaunchRS> call() {
                        return LaunchImpl.this.rpClient.startLaunch(rq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LAUNCH_SUCCESS_CONSUMER).doOnError(LoggingCallback.LOG_ERROR);
                    }
                }).subscribeOn(LaunchImpl.this.scheduler).cache();
                launchPromise.subscribe((Consumer)new Consumer<StartLaunchRS>(){

                    public void accept(StartLaunchRS startLaunchRS) throws Exception {
                        emitter.onSuccess((Object)startLaunchRS.getId());
                    }
                }, (Consumer)new Consumer<Throwable>(){

                    public void accept(Throwable throwable) throws Exception {
                        LoggingCallback.LOG_ERROR.accept((Object)throwable);
                        emitter.onComplete();
                    }
                });
            }
        }).cache();
    }

    protected LaunchImpl(@NotNull ReportPortalClient reportPortalClient, @NotNull ListenerParameters parameters, @NotNull Maybe<String> launchMaybe, @NotNull ExecutorService executorService) {
        super(parameters);
        this.rpClient = Objects.requireNonNull(reportPortalClient, "RestEndpoint shouldn't be NULL");
        Objects.requireNonNull(parameters, "Parameters shouldn't be NULL");
        this.executor = Objects.requireNonNull(executorService);
        this.scheduler = this.createScheduler(this.executor);
        LOGGER.info("Rerun: {}", (Object)parameters.isRerun());
        this.launch = launchMaybe.subscribeOn(this.scheduler).cache();
    }

    protected Scheduler createScheduler(ExecutorService executorService) {
        return SCHEDULERS.computeIfAbsent(executorService, Schedulers::from);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public Maybe<String> start() {
        this.launch.subscribe(SubscriptionUtils.logMaybeResults("Launch start"));
        LaunchLoggingContext.init(this.launch, this.rpClient, this.scheduler, this.getParameters().getBatchLogsSize(), this.getParameters().isConvertImage());
        return this.launch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(FinishExecutionRQ rq) {
        this.QUEUE.getUnchecked(this.launch).addToQueue(LaunchLoggingContext.complete());
        Completable finish = Completable.concat(this.QUEUE.getUnchecked(this.launch).getChildren()).andThen((MaybeSource)this.launch.map(id -> (OperationCompletionRS)this.rpClient.finishLaunch((String)id, rq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LoggingCallback.LOG_SUCCESS).doOnError(LoggingCallback.LOG_ERROR).blockingGet())).ignoreElement().cache();
        try {
            Throwable error = finish.timeout((long)this.getParameters().getReportingTimeout().intValue(), TimeUnit.SECONDS).blockingGet();
            if (error != null) {
                LOGGER.error("Unable to finish launch in ReportPortal", error);
            }
        }
        finally {
            this.rpClient.close();
        }
    }

    private static <T> Maybe<T> createErrorResponse(Throwable cause) {
        LOGGER.error(cause.getMessage(), cause);
        return SubscriptionUtils.createConstantMaybe(cause);
    }

    @Override
    public Maybe<String> startTestItem(StartTestItemRQ rq) {
        if (rq == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("StartTestItemRQ should not be null"));
        }
        Maybe testItem = this.launch.flatMap(launchId -> {
            rq.setLaunchUuid(launchId);
            return this.rpClient.startTestItem(rq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LoggingCallback.logCreated("item")).map(TO_ID);
        }).cache();
        testItem.subscribeOn(this.scheduler).subscribe(SubscriptionUtils.logMaybeResults("Start test item"));
        this.QUEUE.getUnchecked((Maybe<String>)testItem).addToQueue(testItem.ignoreElement().onErrorComplete());
        LoggingContext.init(this.launch, (Maybe<String>)testItem, this.rpClient, this.scheduler, this.getParameters().getBatchLogsSize(), this.getParameters().isConvertImage());
        this.getStepReporter().setParent((Maybe<String>)testItem);
        return testItem;
    }

    @Override
    public Maybe<String> startTestItem(Maybe<String> parentId, Maybe<String> retryOf, StartTestItemRQ rq) {
        return retryOf.flatMap(s -> this.startTestItem(parentId, rq)).cache();
    }

    @Override
    public Maybe<String> startTestItem(final Maybe<String> parentId, final StartTestItemRQ rq) {
        if (null == parentId) {
            return this.startTestItem(rq);
        }
        Maybe itemId = this.launch.flatMap((Function)new Function<String, Maybe<String>>(){

            public Maybe<String> apply(final String launchId) {
                return parentId.flatMap((Function)new Function<String, MaybeSource<String>>(){

                    public MaybeSource<String> apply(String parentId) {
                        rq.setLaunchUuid(launchId);
                        Launch.LOGGER.debug("Starting test item..." + Thread.currentThread().getName());
                        Maybe result = LaunchImpl.this.rpClient.startTestItem(parentId, rq);
                        result = result.retry((Predicate)DEFAULT_REQUEST_RETRY);
                        result = result.doOnSuccess(LoggingCallback.logCreated("item"));
                        return result.map(TO_ID);
                    }
                });
            }
        }).cache();
        itemId.subscribeOn(this.scheduler).subscribe(SubscriptionUtils.logMaybeResults("Start test item"));
        this.QUEUE.getUnchecked((Maybe<String>)itemId).withParent(parentId).addToQueue(itemId.ignoreElement().onErrorComplete());
        LoggingContext.init(this.launch, (Maybe<String>)itemId, this.rpClient, this.scheduler, this.getParameters().getBatchLogsSize(), this.getParameters().isConvertImage());
        this.getStepReporter().setParent((Maybe<String>)itemId);
        return itemId;
    }

    @Override
    public Maybe<OperationCompletionRS> finishTestItem(Maybe<String> item, FinishTestItemRQ rq) {
        if (item == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("ItemID should not be null"));
        }
        if (rq == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("FinishTestItemRQ should not be null"));
        }
        if (ItemStatus.SKIPPED.name().equals(rq.getStatus()) && !this.getParameters().getSkippedAnIssue().booleanValue()) {
            Issue issue = new Issue();
            issue.setIssueType(NOT_ISSUE);
            rq.setIssue(issue);
        }
        this.QUEUE.getUnchecked(this.launch).addToQueue(LoggingContext.complete());
        TreeItem treeItem = (TreeItem)this.QUEUE.getIfPresent(item);
        if (null == treeItem) {
            treeItem = new TreeItem();
            LOGGER.error("Item {} not found in the cache", item);
        }
        if (this.getStepReporter().isFailed(item)) {
            rq.setStatus(ItemStatus.FAILED.name());
        }
        Maybe finishResponse = this.launch.flatMap(launchId -> item.flatMap(itemId -> {
            rq.setLaunchUuid(launchId);
            return this.rpClient.finishTestItem((String)itemId, rq).retry((Predicate)TEST_ITEM_FINISH_REQUEST_RETRY).doOnSuccess(LoggingCallback.LOG_SUCCESS).doOnError(LoggingCallback.LOG_ERROR);
        })).cache();
        Completable finishCompletion = Completable.concat(treeItem.getChildren()).andThen((MaybeSource)finishResponse).doAfterTerminate(() -> this.QUEUE.invalidate(item)).ignoreElement().cache();
        finishCompletion.subscribeOn(this.scheduler).subscribe(SubscriptionUtils.logCompletableResults("Finish test item"));
        Maybe<String> parent = treeItem.getParent();
        if (null != parent) {
            this.QUEUE.getUnchecked(parent).addToQueue(finishCompletion.onErrorComplete());
        } else {
            this.QUEUE.getUnchecked(this.launch).addToQueue(finishCompletion.onErrorComplete());
        }
        this.getStepReporter().removeParent(item);
        return finishResponse;
    }

    protected static class TreeItem {
        private volatile Maybe<String> parent;
        private final List<Completable> children = new CopyOnWriteArrayList<Completable>();

        protected TreeItem() {
        }

        public TreeItem withParent(Maybe<String> parent) {
            this.parent = parent;
            return this;
        }

        public TreeItem addToQueue(Completable completable) {
            this.children.add(completable);
            return this;
        }

        public List<Completable> getChildren() {
            return Lists.newArrayList(this.children);
        }

        public Maybe<String> getParent() {
            return this.parent;
        }
    }
}

