/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.reportportal.utils.files.ImageConverter;
import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.subjects.PublishSubject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import rp.com.google.common.io.ByteSource;

public class LaunchLoggingContext {
    private static final int DEFAULT_BUFFER_SIZE = 10;
    static final String DEFAULT_LAUNCH_KEY = "default";
    static ConcurrentHashMap<String, LaunchLoggingContext> loggingContextMap = new ConcurrentHashMap();
    private final PublishSubject<Maybe<SaveLogRQ>> emitter;
    private final Maybe<String> launchUuid;
    private final boolean convertImages;

    private LaunchLoggingContext(Maybe<String> launchUuid, ReportPortalClient client, Scheduler scheduler, int bufferSize, boolean convertImages) {
        this.launchUuid = launchUuid;
        this.emitter = PublishSubject.create();
        this.convertImages = convertImages;
        this.emitter.toFlowable(BackpressureStrategy.BUFFER).flatMap(Maybe::toFlowable).buffer(bufferSize).flatMap(rqs -> client.log(HttpRequestUtils.buildLogMultiPartRequest(rqs)).toFlowable()).doOnError(Throwable::printStackTrace).observeOn(scheduler).subscribe(SubscriptionUtils.logFlowableResults("Launch logging context"));
    }

    static LaunchLoggingContext init(Maybe<String> launchUuid, ReportPortalClient client, Scheduler scheduler) {
        return LaunchLoggingContext.init(launchUuid, client, scheduler, 10, false);
    }

    static LaunchLoggingContext init(Maybe<String> launchUuid, ReportPortalClient client, Scheduler scheduler, int bufferSize, boolean convertImages) {
        LaunchLoggingContext context = new LaunchLoggingContext(launchUuid, client, scheduler, bufferSize, convertImages);
        loggingContextMap.put(DEFAULT_LAUNCH_KEY, context);
        return context;
    }

    public static Completable complete() {
        LaunchLoggingContext loggingContext = loggingContextMap.get(DEFAULT_LAUNCH_KEY);
        if (null != loggingContext) {
            return loggingContext.completed();
        }
        return Maybe.empty().ignoreElement();
    }

    void emit(Function<String, SaveLogRQ> logSupplier) {
        this.emitter.onNext((Object)this.launchUuid.map(input -> {
            SaveLogRQ rq = (SaveLogRQ)logSupplier.apply((String)input);
            SaveLogRQ.File file = rq.getFile();
            if (this.convertImages && null != file && ImageConverter.isImage(file.getContentType())) {
                TypeAwareByteSource source = ImageConverter.convert(ByteSource.wrap(file.getContent()));
                file.setContent(source.read());
                file.setContentType(source.getMediaType());
            }
            return rq;
        }));
    }

    private Completable completed() {
        this.emitter.onComplete();
        return this.emitter.ignoreElements();
    }
}

