/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.files;

import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.utils.MimeTypeDetector;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import javax.validation.constraints.NotNull;
import rp.com.google.common.io.ByteSource;

public class Utils {
    private static final int KILOBYTE = 8;
    private static final int READ_BUFFER = 80;

    private Utils() {
    }

    public static String readInputStreamToString(@NotNull InputStream is) throws IOException {
        byte[] bytes = Utils.readInputStreamToBytes(is);
        if (bytes.length <= 0) {
            return "";
        }
        try {
            return new String(bytes, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static byte[] readInputStreamToBytes(@NotNull InputStream is) throws IOException {
        return Utils.readInputStreamToBytes(is, 80);
    }

    public static byte[] readInputStreamToBytes(@NotNull InputStream is, int bufferSize) throws IOException {
        int read;
        ReadableByteChannel channel = Channels.newChannel(is);
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((read = channel.read(buffer)) > 0) {
            baos.write(buffer.array(), 0, read);
            buffer.clear();
        }
        return baos.toByteArray();
    }

    public static byte[] readFileToBytes(@NotNull File file) throws IOException {
        return Utils.readInputStreamToBytes(new FileInputStream(file));
    }

    public static TypeAwareByteSource getFile(@NotNull File file) throws IOException {
        byte[] data;
        if (file.exists() && file.isFile()) {
            data = Utils.readFileToBytes(file);
        } else {
            String path = file.getPath();
            InputStream resource = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
            if (resource == null) {
                throw new FileNotFoundException("Unable to locate file of path: " + file.getPath());
            }
            data = Utils.readInputStreamToBytes(resource);
        }
        String name = file.getName();
        ByteSource byteSource = ByteSource.wrap(data);
        return new TypeAwareByteSource(byteSource, MimeTypeDetector.detect(byteSource, name));
    }
}

