/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.properties;

import com.epam.reportportal.utils.properties.DefaultProperties;
import com.epam.reportportal.utils.properties.PropertyHolder;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemAttributesExtractor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemAttributesExtractor.class);
    private static final String ATTRIBUTE_VALUE_SEPARATOR = "|";

    private SystemAttributesExtractor() {
    }

    public static Set<ItemAttributesRQ> extract(String resource, ClassLoader loader) {
        Set<ItemAttributesRQ> attributes = SystemAttributesExtractor.getInternalAttributes();
        Properties properties = SystemAttributesExtractor.loadProperties(resource, loader);
        attributes.addAll(SystemAttributesExtractor.getExternalAttributes(properties, DefaultProperties.values()));
        return attributes;
    }

    public static Set<ItemAttributesRQ> extract(String resource, ClassLoader loader, PropertyHolder ... propertyHolders) {
        Properties properties = SystemAttributesExtractor.loadProperties(resource, loader);
        return SystemAttributesExtractor.getExternalAttributes(properties, propertyHolders);
    }

    private static Properties loadProperties(String resource, ClassLoader loader) {
        Properties properties = new Properties();
        Optional.ofNullable(loader).flatMap(l -> Optional.ofNullable(resource).flatMap(res -> Optional.ofNullable(l.getResourceAsStream((String)res)))).ifPresent(resStream -> {
            try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)resStream, StandardCharsets.UTF_8);){
                properties.load(inputStreamReader);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to load system properties file");
            }
        });
        return properties;
    }

    public static Set<ItemAttributesRQ> extract(Path path) {
        Set<ItemAttributesRQ> attributes = SystemAttributesExtractor.getInternalAttributes();
        Properties properties = SystemAttributesExtractor.loadProperties(path);
        attributes.addAll(SystemAttributesExtractor.getExternalAttributes(properties, DefaultProperties.values()));
        return attributes;
    }

    public static Set<ItemAttributesRQ> extract(Path path, PropertyHolder ... propertyHolders) {
        Properties properties = SystemAttributesExtractor.loadProperties(path);
        return SystemAttributesExtractor.getExternalAttributes(properties, propertyHolders);
    }

    private static Properties loadProperties(Path path) {
        Properties properties = new Properties();
        Optional.ofNullable(path).ifPresent(p -> {
            File file = p.toFile();
            if (file.exists()) {
                try (InputStreamReader inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);){
                    properties.load(inputStreamReader);
                }
                catch (IOException e) {
                    LOGGER.warn("Unable to load system properties file");
                }
            }
        });
        return properties;
    }

    private static Set<ItemAttributesRQ> getInternalAttributes() {
        return Arrays.stream(DefaultProperties.values()).filter(DefaultProperties::isInternal).map(defaultProperty -> SystemAttributesExtractor.convert(defaultProperty.getName(), defaultProperty.getPropertyKeys())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private static Set<ItemAttributesRQ> getExternalAttributes(Properties externalAttributes, PropertyHolder ... propertyHolders) {
        return Arrays.stream(propertyHolders).filter(defaultProperties -> !defaultProperties.isInternal()).map(defaultProperty -> SystemAttributesExtractor.convert(defaultProperty.getName(), externalAttributes, defaultProperty.getPropertyKeys())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private static Optional<ItemAttributesRQ> convert(String attributeKey, Properties properties, String ... propertyKeys) {
        Function<String, Optional<String>> propertyExtractor = SystemAttributesExtractor.getPropertyExtractor(properties);
        return SystemAttributesExtractor.extractAttribute(propertyExtractor, attributeKey, propertyKeys);
    }

    private static Optional<ItemAttributesRQ> convert(String attributeKey, String ... propertyKeys) {
        Function<String, Optional<String>> propertyExtractor = SystemAttributesExtractor.getPropertyExtractor();
        return SystemAttributesExtractor.extractAttribute(propertyExtractor, attributeKey, propertyKeys);
    }

    private static Function<String, Optional<String>> getPropertyExtractor(Properties properties) {
        return key -> Optional.ofNullable(properties.getProperty((String)key));
    }

    private static Function<String, Optional<String>> getPropertyExtractor() {
        return key -> Optional.ofNullable(System.getProperty(key));
    }

    private static Optional<ItemAttributesRQ> extractAttribute(Function<String, Optional<String>> propertyExtractor, String attributeKey, String ... propertyKeys) {
        List values = Arrays.stream(propertyKeys).map(propertyExtractor).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (!values.isEmpty()) {
            return Optional.of(new ItemAttributesRQ(attributeKey, StringUtils.join(values, (String)ATTRIBUTE_VALUE_SEPARATOR), true));
        }
        return Optional.empty();
    }
}

