/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.aspect.StepAspect;
import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.exception.ReportPortalException;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.LaunchLoggingContext;
import com.epam.reportportal.service.LoggingCallback;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.analytics.AnalyticsService;
import com.epam.reportportal.utils.RetryWithDelay;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.reportportal.utils.properties.DefaultProperties;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.item.ItemCreatedRS;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Scheduler;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import rp.com.google.common.cache.CacheBuilder;
import rp.com.google.common.cache.CacheLoader;
import rp.com.google.common.cache.LoadingCache;
import rp.com.google.common.collect.Lists;

public class LaunchImpl
extends Launch {
    private static final Map<ExecutorService, Scheduler> SCHEDULERS = new ConcurrentHashMap<ExecutorService, Scheduler>();
    private static final Function<ItemCreatedRS, String> TO_ID = EntryCreatedAsyncRS::getId;
    private static final Consumer<StartLaunchRS> LAUNCH_SUCCESS_CONSUMER = rs -> {
        LoggingCallback.logCreated("launch").accept(rs);
        System.setProperty("rp.launch.id", String.valueOf(rs.getId()));
    };
    private static final int DEFAULT_RETRY_COUNT = 5;
    private static final int DEFAULT_RETRY_TIMEOUT = 2;
    private static final int ITEM_FINISH_MAX_RETRIES = 10;
    private static final int ITEM_FINISH_RETRY_TIMEOUT = 10;
    private static final Predicate<Throwable> INTERNAL_CLIENT_EXCEPTION_PREDICATE = throwable -> throwable instanceof InternalReportPortalClientException;
    private static final Predicate<Throwable> TEST_ITEM_FINISH_RETRY_PREDICATE = throwable -> throwable instanceof ReportPortalException && ErrorType.FINISH_ITEM_NOT_ALLOWED.equals((Object)((ReportPortalException)throwable).getError().getErrorType()) || INTERNAL_CLIENT_EXCEPTION_PREDICATE.test(throwable);
    private static final RetryWithDelay DEFAULT_REQUEST_RETRY = new RetryWithDelay(INTERNAL_CLIENT_EXCEPTION_PREDICATE, 5L, TimeUnit.SECONDS.toMillis(2L));
    private static final RetryWithDelay TEST_ITEM_FINISH_REQUEST_RETRY = new RetryWithDelay(TEST_ITEM_FINISH_RETRY_PREDICATE, 10L, TimeUnit.SECONDS.toMillis(10L));
    public static final String NOT_ISSUE = "NOT_ISSUE";
    public static final String CUSTOM_AGENT = "CUSTOM";
    private final ReportPortalClient rpClient;
    protected final LoadingCache<Maybe<String>, TreeItem> QUEUE = CacheBuilder.newBuilder().build(new CacheLoader<Maybe<String>, TreeItem>(){

        @Override
        public TreeItem load(@Nonnull Maybe<String> key) {
            return new TreeItem();
        }
    });
    protected final Maybe<String> launch;
    private final ExecutorService executor;
    private final Scheduler scheduler;
    private final AnalyticsService analyticsService;
    private final StartLaunchRQ startRq;

    protected LaunchImpl(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters parameters, @Nonnull StartLaunchRQ rq, @Nonnull ExecutorService executorService) {
        super(parameters);
        this.rpClient = Objects.requireNonNull(reportPortalClient, "RestEndpoint shouldn't be NULL");
        Objects.requireNonNull(parameters, "Parameters shouldn't be NULL");
        this.executor = Objects.requireNonNull(executorService);
        this.scheduler = this.createScheduler(this.executor);
        this.analyticsService = new AnalyticsService(parameters);
        this.startRq = rq;
        LOGGER.info("Rerun: {}", (Object)parameters.isRerun());
        this.launch = Maybe.create(emitter -> {
            Maybe launchPromise = Maybe.defer(() -> this.rpClient.startLaunch(rq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LAUNCH_SUCCESS_CONSUMER).doOnError(LoggingCallback.LOG_ERROR)).subscribeOn(this.getScheduler()).cache();
            launchPromise.subscribe(rs -> emitter.onSuccess((Object)rs.getId()), t -> {
                LoggingCallback.LOG_ERROR.accept(t);
                emitter.onComplete();
            });
        }).cache();
    }

    protected LaunchImpl(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters parameters, @Nonnull Maybe<String> launchMaybe, @Nonnull ExecutorService executorService) {
        super(parameters);
        this.rpClient = Objects.requireNonNull(reportPortalClient, "RestEndpoint shouldn't be NULL");
        Objects.requireNonNull(parameters, "Parameters shouldn't be NULL");
        this.executor = Objects.requireNonNull(executorService);
        this.scheduler = this.createScheduler(this.executor);
        this.analyticsService = new AnalyticsService(parameters);
        this.startRq = LaunchImpl.emptyStartLaunchForAnalytics();
        LOGGER.info("Rerun: {}", (Object)parameters.isRerun());
        this.launch = launchMaybe.cache();
    }

    private static StartLaunchRQ emptyStartLaunchForAnalytics() {
        StartLaunchRQ result = new StartLaunchRQ();
        result.setAttributes(Collections.singleton(new ItemAttributesRQ(DefaultProperties.AGENT.getName(), CUSTOM_AGENT, true)));
        return result;
    }

    protected Scheduler createScheduler(ExecutorService executorService) {
        return SCHEDULERS.computeIfAbsent(executorService, Schedulers::from);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    AnalyticsService getAnalyticsService() {
        return this.analyticsService;
    }

    @Override
    public Maybe<String> start() {
        this.launch.subscribe(SubscriptionUtils.logMaybeResults("Launch start"));
        LaunchLoggingContext.init(this.launch, this.rpClient, this.getScheduler(), this.getParameters().getBatchLogsSize(), this.getParameters().isConvertImage());
        this.getAnalyticsService().sendEvent(this.launch, this.startRq);
        return this.launch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finish(FinishExecutionRQ rq) {
        this.QUEUE.getUnchecked(this.launch).addToQueue(LaunchLoggingContext.complete());
        Completable finish = Completable.concat(this.QUEUE.getUnchecked(this.launch).getChildren()).andThen((MaybeSource)this.launch.map(id -> (OperationCompletionRS)this.rpClient.finishLaunch((String)id, rq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LoggingCallback.LOG_SUCCESS).doOnError(LoggingCallback.LOG_ERROR).blockingGet())).ignoreElement().cache();
        try {
            try {
                Throwable error = finish.timeout((long)this.getParameters().getReportingTimeout().intValue(), TimeUnit.SECONDS).blockingGet();
                if (error != null) {
                    LOGGER.error("Unable to finish launch in ReportPortal", error);
                }
            }
            finally {
                this.rpClient.close();
            }
        }
        finally {
            this.getAnalyticsService().close();
        }
    }

    private static <T> Maybe<T> createErrorResponse(Throwable cause) {
        LOGGER.error(cause.getMessage(), cause);
        return SubscriptionUtils.createConstantMaybe(cause);
    }

    @Override
    public Maybe<String> startTestItem(StartTestItemRQ rq) {
        if (rq == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("StartTestItemRQ should not be null"));
        }
        Maybe item = this.launch.flatMap(launchId -> {
            rq.setLaunchUuid(launchId);
            return this.rpClient.startTestItem(rq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LoggingCallback.logCreated("item")).map(TO_ID);
        }).cache();
        item.subscribeOn(this.getScheduler()).subscribe(SubscriptionUtils.logMaybeResults("Start test item"));
        this.QUEUE.getUnchecked((Maybe<String>)item).addToQueue(item.ignoreElement().onErrorComplete());
        LoggingContext.init(this.launch, (Maybe<String>)item, this.rpClient, this.getScheduler(), this.getParameters().getBatchLogsSize(), this.getParameters().isConvertImage());
        this.getStepReporter().setParent((Maybe<String>)item);
        StepAspect.setParentId((Maybe<String>)item);
        return item;
    }

    @Override
    public Maybe<String> startTestItem(Maybe<String> parentId, Maybe<String> retryOf, StartTestItemRQ rq) {
        return retryOf.flatMap(s -> this.startTestItem(parentId, rq)).cache();
    }

    @Override
    public Maybe<String> startTestItem(Maybe<String> parentId, StartTestItemRQ rq) {
        if (null == parentId) {
            return this.startTestItem(rq);
        }
        Maybe item = this.launch.flatMap(lId -> parentId.flatMap(pId -> {
            rq.setLaunchUuid(lId);
            LOGGER.debug("Starting test item..." + Thread.currentThread().getName());
            Maybe result = this.rpClient.startTestItem((String)pId, rq);
            result = result.retry((Predicate)DEFAULT_REQUEST_RETRY);
            result = result.doOnSuccess(LoggingCallback.logCreated("item"));
            return result.map(TO_ID);
        })).cache();
        item.subscribeOn(this.getScheduler()).subscribe(SubscriptionUtils.logMaybeResults("Start test item"));
        this.QUEUE.getUnchecked((Maybe<String>)item).withParent(parentId).addToQueue(item.ignoreElement().onErrorComplete());
        LoggingContext.init(this.launch, (Maybe<String>)item, this.rpClient, this.getScheduler(), this.getParameters().getBatchLogsSize(), this.getParameters().isConvertImage());
        this.getStepReporter().setParent((Maybe<String>)item);
        StepAspect.setParentId((Maybe<String>)item);
        return item;
    }

    @Override
    public Maybe<OperationCompletionRS> finishTestItem(Maybe<String> item, FinishTestItemRQ rq) {
        if (item == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("ItemID should not be null"));
        }
        if (rq == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("FinishTestItemRQ should not be null"));
        }
        if (ItemStatus.SKIPPED.name().equals(rq.getStatus()) && !this.getParameters().getSkippedAnIssue().booleanValue()) {
            Issue issue = new Issue();
            issue.setIssueType(NOT_ISSUE);
            rq.setIssue(issue);
        }
        this.QUEUE.getUnchecked(this.launch).addToQueue(LoggingContext.complete());
        TreeItem treeItem = (TreeItem)this.QUEUE.getIfPresent(item);
        if (null == treeItem) {
            treeItem = new TreeItem();
            LOGGER.error("Item {} not found in the cache", item);
        }
        if (this.getStepReporter().isFailed(item)) {
            rq.setStatus(ItemStatus.FAILED.name());
        }
        Maybe finishResponse = this.launch.flatMap(launchId -> item.flatMap(itemId -> {
            rq.setLaunchUuid(launchId);
            return this.rpClient.finishTestItem((String)itemId, rq).retry((Predicate)TEST_ITEM_FINISH_REQUEST_RETRY).doOnSuccess(LoggingCallback.LOG_SUCCESS).doOnError(LoggingCallback.LOG_ERROR);
        })).cache();
        Completable finishCompletion = Completable.concat(treeItem.getChildren()).andThen((MaybeSource)finishResponse).doAfterTerminate(() -> this.QUEUE.invalidate(item)).ignoreElement().cache();
        finishCompletion.subscribeOn(this.getScheduler()).subscribe(SubscriptionUtils.logCompletableResults("Finish test item"));
        Maybe<String> parent = treeItem.getParent();
        if (null != parent) {
            this.QUEUE.getUnchecked(parent).addToQueue(finishCompletion.onErrorComplete());
        } else {
            this.QUEUE.getUnchecked(this.launch).addToQueue(finishCompletion.onErrorComplete());
        }
        this.getStepReporter().removeParent(item);
        StepAspect.removeParentId(item);
        return finishResponse;
    }

    protected static class TreeItem {
        private volatile Maybe<String> parent;
        private final List<Completable> children = new CopyOnWriteArrayList<Completable>();

        protected TreeItem() {
        }

        public TreeItem withParent(Maybe<String> parent) {
            this.parent = parent;
            return this;
        }

        public TreeItem addToQueue(Completable completable) {
            this.children.add(completable);
            return this;
        }

        public List<Completable> getChildren() {
            return Lists.newArrayList(this.children);
        }

        public Maybe<String> getParent() {
            return this.parent;
        }
    }
}

