/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.analytics;

import com.epam.reportportal.service.analytics.item.AnalyticsItem;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.org.apache.http.HttpHost;
import rp.org.apache.http.HttpResponse;
import rp.org.apache.http.NameValuePair;
import rp.org.apache.http.client.HttpClient;
import rp.org.apache.http.client.entity.UrlEncodedFormEntity;
import rp.org.apache.http.client.methods.CloseableHttpResponse;
import rp.org.apache.http.client.methods.HttpPost;
import rp.org.apache.http.impl.client.CloseableHttpClient;
import rp.org.apache.http.impl.client.HttpClientBuilder;
import rp.org.apache.http.impl.client.HttpClients;
import rp.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import rp.org.apache.http.message.BasicNameValuePair;
import rp.org.apache.http.util.EntityUtils;

public class GoogleAnalytics
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoogleAnalytics.class);
    private static final Function<Map<String, String>, List<NameValuePair>> PARAMETERS_CONVERTER = params -> params.entrySet().stream().map(entry -> new BasicNameValuePair((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
    private static final String DEFAULT_BASE_URL = "https://www.google-analytics.com/collect";
    private static final String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.131 Safari/537.36";
    private final String baseUrl;
    private final List<NameValuePair> defaultRequestParams = new ArrayList<NameValuePair>();
    private final HttpClient httpClient;

    public GoogleAnalytics(String trackingId, String proxyUrl) {
        this(trackingId, GoogleAnalytics.buildDefaultHttpClient(proxyUrl));
    }

    public GoogleAnalytics(String trackingId, HttpClient httpClient) {
        this.baseUrl = DEFAULT_BASE_URL;
        Collections.addAll(this.defaultRequestParams, new BasicNameValuePair("de", "UTF-8"), new BasicNameValuePair("v", "1"), new BasicNameValuePair("cid", UUID.randomUUID().toString()), new BasicNameValuePair("tid", trackingId));
        this.httpClient = httpClient;
    }

    private static HttpClient buildDefaultHttpClient(String proxyUrl) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(1);
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager(connectionManager).setUserAgent(USER_AGENT);
        Optional.ofNullable(proxyUrl).ifPresent(u -> httpClientBuilder.setProxy(HttpHost.create(proxyUrl)));
        return httpClientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean send(AnalyticsItem item) {
        try {
            HttpPost httpPost = this.buildPostRequest(item);
            HttpResponse response = this.httpClient.execute(httpPost);
            try {
                EntityUtils.consumeQuietly(response.getEntity());
            }
            finally {
                if (response instanceof CloseableHttpResponse) {
                    ((CloseableHttpResponse)response).close();
                }
            }
            return true;
        }
        catch (Throwable ex) {
            LOGGER.error(ex.getMessage());
            return false;
        }
    }

    private HttpPost buildPostRequest(AnalyticsItem item) {
        List<NameValuePair> nameValuePairs = PARAMETERS_CONVERTER.apply(item.getParams());
        nameValuePairs.addAll(this.defaultRequestParams);
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nameValuePairs, StandardCharsets.UTF_8);
        HttpPost httpPost = new HttpPost(this.baseUrl);
        httpPost.setEntity(entity);
        return httpPost;
    }

    @Override
    public void close() {
        if (this.httpClient instanceof CloseableHttpClient) {
            try {
                ((CloseableHttpClient)this.httpClient).close();
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage());
            }
        }
    }
}

