/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.ReportPortalMessage;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.restendpoint.http.HttpClientRestEndpoint;
import com.epam.reportportal.restendpoint.http.RestEndpoint;
import com.epam.reportportal.restendpoint.http.RestEndpoints;
import com.epam.reportportal.restendpoint.serializer.ByteArraySerializer;
import com.epam.reportportal.restendpoint.serializer.Serializer;
import com.epam.reportportal.restendpoint.serializer.json.JacksonSerializer;
import com.epam.reportportal.service.BearerAuthInterceptor;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.LaunchImpl;
import com.epam.reportportal.service.LaunchLoggingContext;
import com.epam.reportportal.service.LockFile;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.ReportPortalErrorHandler;
import com.epam.reportportal.service.launch.PrimaryLaunch;
import com.epam.reportportal.service.launch.SecondaryLaunch;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.reportportal.utils.SslUtils;
import com.epam.reportportal.utils.files.Utils;
import com.epam.reportportal.utils.properties.ListenerProperty;
import com.epam.reportportal.utils.properties.PropertiesLoader;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Maybe;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.util.concurrent.ThreadFactoryBuilder;
import rp.org.apache.http.HttpHost;
import rp.org.apache.http.HttpResponse;
import rp.org.apache.http.client.HttpClient;
import rp.org.apache.http.client.config.RequestConfig;
import rp.org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import rp.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import rp.org.apache.http.impl.client.HttpClientBuilder;
import rp.org.apache.http.impl.client.HttpClients;
import rp.org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import rp.org.apache.http.protocol.HttpContext;
import rp.org.apache.http.ssl.SSLContextBuilder;

public class ReportPortal {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportPortal.class);
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private final AtomicReference<String> instanceUuid = new AtomicReference<String>(UUID.randomUUID().toString());
    private final ListenerParameters parameters;
    private final LockFile lockFile;
    private final ReportPortalClient rpClient;
    private final ExecutorService executor;

    ReportPortal(@Nullable ReportPortalClient rpClient, @Nonnull ExecutorService executor, @Nonnull ListenerParameters parameters, @Nullable LockFile lockFile) {
        this.rpClient = rpClient;
        this.executor = executor;
        this.parameters = parameters;
        this.lockFile = lockFile;
    }

    public Launch newLaunch(StartLaunchRQ rq) {
        if (BooleanUtils.isNotTrue((Boolean)this.parameters.getEnable()) || this.rpClient == null) {
            return Launch.NOOP_LAUNCH;
        }
        if (this.lockFile == null) {
            return new LaunchImpl(this.rpClient, this.parameters, rq, this.executor);
        }
        String uuid = this.lockFile.obtainLaunchUuid(this.instanceUuid.get());
        if (uuid == null) {
            return new LaunchImpl(this.rpClient, this.parameters, rq, this.executor);
        }
        if (this.instanceUuid.get().equals(uuid)) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                StartLaunchRQ rqCopy = (StartLaunchRQ)objectMapper.readValue(objectMapper.writeValueAsString((Object)rq), StartLaunchRQ.class);
                rqCopy.setUuid(uuid);
                return new PrimaryLaunch(this.rpClient, this.parameters, rqCopy, this.executor, this.lockFile, this.instanceUuid);
            }
            catch (IOException e) {
                throw new InternalReportPortalClientException("Unable to clone start launch request:", e);
            }
        }
        Maybe launch = Maybe.create(emitter -> {
            emitter.onSuccess((Object)uuid);
            emitter.onComplete();
        });
        return new SecondaryLaunch(this.rpClient, this.parameters, (Maybe<String>)launch, this.executor, this.lockFile, this.instanceUuid);
    }

    public Launch withLaunch(Maybe<String> launchUuid) {
        return Optional.ofNullable(this.rpClient).map(c -> new LaunchImpl((ReportPortalClient)c, this.parameters, launchUuid, this.executor)).orElse(Launch.NOOP_LAUNCH);
    }

    public ListenerParameters getParameters() {
        return this.parameters;
    }

    public ReportPortalClient getClient() {
        return this.rpClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static LockFile getLockFile(ListenerParameters parameters) {
        if (parameters.getClientJoin()) {
            return new LockFile(parameters);
        }
        return null;
    }

    public static ReportPortal create(ReportPortalClient client, ListenerParameters params) {
        return ReportPortal.create(client, params, ReportPortal.buildExecutorService(params));
    }

    public static ReportPortal create(@Nonnull ReportPortalClient client, @Nonnull ListenerParameters params, @Nonnull ExecutorService executor) {
        return new ReportPortal(client, executor, params, ReportPortal.getLockFile(params));
    }

    public static boolean emitLog(Function<String, SaveLogRQ> logSupplier) {
        LoggingContext loggingContext = LoggingContext.CONTEXT_THREAD_LOCAL.get().peek();
        if (null != loggingContext) {
            loggingContext.emit(logSupplier);
            return true;
        }
        return false;
    }

    public static boolean emitLaunchLog(Function<String, SaveLogRQ> logSupplier) {
        LaunchLoggingContext launchLoggingContext = LaunchLoggingContext.loggingContextMap.get("default");
        if (null != launchLoggingContext) {
            launchLoggingContext.emit(logSupplier);
            return true;
        }
        return false;
    }

    public static boolean emitLog(String message, String level, Date time) {
        return ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setLevel(level);
            rq.setLogTime(time);
            rq.setItemUuid(itemUuid);
            rq.setMessage(message);
            return rq;
        });
    }

    public static boolean emitLaunchLog(String message, String level, Date time) {
        return ReportPortal.emitLaunchLog(launchUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setLevel(level);
            rq.setLogTime(time);
            rq.setLaunchUuid(launchUuid);
            rq.setMessage(message);
            return rq;
        });
    }

    private static void fillSaveLogRQ(SaveLogRQ rq, String message, String level, Date time, File file) {
        rq.setMessage(message);
        rq.setLevel(level);
        rq.setLogTime(time);
        try {
            SaveLogRQ.File f = new SaveLogRQ.File();
            f.setContentType(MimeTypeDetector.detect(file));
            f.setContent(Utils.readFileToBytes(file));
            f.setName(UUID.randomUUID().toString());
            rq.setFile(f);
        }
        catch (IOException e) {
            LOGGER.error("Cannot send file to ReportPortal", (Throwable)e);
        }
    }

    public static boolean emitLog(String message, String level, Date time, File file) {
        return ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setItemUuid(itemUuid);
            ReportPortal.fillSaveLogRQ(rq, message, level, time, file);
            return rq;
        });
    }

    public static boolean emitLaunchLog(String message, String level, Date time, File file) {
        return ReportPortal.emitLaunchLog(launchUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setLaunchUuid(launchUuid);
            ReportPortal.fillSaveLogRQ(rq, message, level, time, file);
            return rq;
        });
    }

    private static void fillSaveLogRQ(SaveLogRQ rq, String level, Date time, ReportPortalMessage message) {
        rq.setLevel(level);
        rq.setLogTime(time);
        rq.setMessage(message.getMessage());
        try {
            TypeAwareByteSource data = message.getData();
            SaveLogRQ.File file = new SaveLogRQ.File();
            file.setContent(data.read());
            file.setContentType(data.getMediaType());
            file.setName(UUID.randomUUID().toString());
            rq.setFile(file);
        }
        catch (Exception e) {
            LOGGER.error("Cannot send file to ReportPortal", (Throwable)e);
        }
    }

    public static boolean emitLog(ReportPortalMessage message, String level, Date time) {
        return ReportPortal.emitLog(itemUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setItemUuid(itemUuid);
            ReportPortal.fillSaveLogRQ(rq, level, time, message);
            return rq;
        });
    }

    public static boolean emitLaunchLog(ReportPortalMessage message, String level, Date time) {
        return ReportPortal.emitLaunchLog(launchUuid -> {
            SaveLogRQ rq = new SaveLogRQ();
            rq.setLaunchUuid(launchUuid);
            ReportPortal.fillSaveLogRQ(rq, level, time, message);
            return rq;
        });
    }

    private static ExecutorService buildExecutorService(ListenerParameters params) {
        return Executors.newFixedThreadPool(params.getIoPoolSize(), new ThreadFactoryBuilder().setNameFormat("rp-io-%s").build());
    }

    public static class Builder {
        static final String API_V1_BASE = "/api/v1";
        static final String API_V2_BASE = "/api/v2";
        private static final String HTTPS = "https";
        private HttpClientBuilder httpClient;
        private ListenerParameters parameters;
        private ExecutorService executor;

        public Builder withHttpClient(HttpClientBuilder client) {
            this.httpClient = client;
            return this;
        }

        public Builder withParameters(ListenerParameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder withExecutorService(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public ReportPortal build() {
            try {
                ListenerParameters params = Optional.ofNullable(this.parameters).orElse(new ListenerParameters(this.defaultPropertiesLoader()));
                ExecutorService executorService = this.executor == null ? this.buildExecutorService(params) : this.executor;
                return new ReportPortal(this.buildClient(ReportPortalClient.class, params, executorService), executorService, params, this.buildLockFile(params));
            }
            catch (Exception e) {
                String errMsg = "Cannot build ReportPortal client";
                LOGGER.error(errMsg, (Throwable)e);
                throw new InternalReportPortalClientException(errMsg, e);
            }
        }

        public <T extends ReportPortalClient> T buildClient(@Nonnull Class<T> clientType, @Nonnull ListenerParameters params) {
            return this.buildClient(clientType, params, this.buildExecutorService(params));
        }

        public <T extends ReportPortalClient> T buildClient(@Nonnull Class<T> clientType, @Nonnull ListenerParameters params, @Nonnull ExecutorService executor) {
            try {
                HttpClient client = Optional.ofNullable(this.httpClient).map(c -> c.addInterceptorLast(new BearerAuthInterceptor(params.getApiKey())).build()).orElseGet(() -> this.defaultClient(params));
                return (T)((ReportPortalClient)Optional.ofNullable(client).map(c -> (ReportPortalClient)RestEndpoints.forInterface(clientType, this.buildRestEndpoint(params, (HttpClient)c, executor))).orElse(null));
            }
            catch (Exception e) {
                String errMsg = "Cannot build ReportPortal client";
                LOGGER.error(errMsg, (Throwable)e);
                throw new InternalReportPortalClientException(errMsg, e);
            }
        }

        protected RestEndpoint buildRestEndpoint(@Nonnull ListenerParameters parameters, @Nonnull HttpClient client) {
            return this.buildRestEndpoint(parameters, client, this.buildExecutorService(parameters));
        }

        protected RestEndpoint buildRestEndpoint(@Nonnull ListenerParameters parameters, @Nonnull HttpClient client, @Nonnull ExecutorService executor) {
            ObjectMapper om = new ObjectMapper();
            om.setDateFormat((DateFormat)new SimpleDateFormat(ReportPortal.DEFAULT_DATE_FORMAT));
            om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            String baseUrl = parameters.getBaseUrl();
            String project = parameters.getProjectName();
            final JacksonSerializer jacksonSerializer = new JacksonSerializer(om);
            return new HttpClientRestEndpoint(client, (List<Serializer>)new LinkedList<Serializer>(){
                {
                    this.add(jacksonSerializer);
                    this.add(new ByteArraySerializer());
                }
            }, new ReportPortalErrorHandler(jacksonSerializer), this.buildEndpointUrl(baseUrl, project, parameters.isAsyncReporting()), executor);
        }

        protected String buildEndpointUrl(String baseUrl, String project, boolean asyncReporting) {
            String apiBase = asyncReporting ? API_V2_BASE : API_V1_BASE;
            return baseUrl + apiBase + "/" + project;
        }

        protected HttpClient defaultClient(final ListenerParameters parameters) {
            String proxyUrl;
            URL baseUrl;
            String baseUrlStr = parameters.getBaseUrl();
            if (baseUrlStr == null) {
                LOGGER.warn("Base url for Report Portal server is not set!");
                return null;
            }
            try {
                baseUrl = new URL(baseUrlStr);
            }
            catch (MalformedURLException e) {
                LOGGER.warn("Unable to parse Report Portal URL", (Throwable)e);
                return null;
            }
            String keyStore = parameters.getKeystore();
            String keyStorePassword = parameters.getKeystorePassword();
            HttpClientBuilder builder = HttpClients.custom();
            if (HTTPS.equals(baseUrl.getProtocol()) && keyStore != null) {
                if (null == keyStorePassword) {
                    throw new InternalReportPortalClientException("You should provide keystore password parameter [" + (Object)((Object)ListenerProperty.KEYSTORE_PASSWORD) + "] if you use HTTPS protocol");
                }
                try {
                    builder.setSSLContext(SSLContextBuilder.create().loadTrustMaterial(SslUtils.loadKeyStore(keyStore, keyStorePassword), TrustSelfSignedStrategy.INSTANCE).build());
                }
                catch (Exception e) {
                    throw new InternalReportPortalClientException("Unable to load trust store");
                }
            }
            if ((proxyUrl = parameters.getProxyUrl()) != null) {
                builder.setProxy(HttpHost.create(proxyUrl));
            }
            builder.setDefaultRequestConfig(RequestConfig.custom().setCookieSpec("standard").build()).setRetryHandler(new StandardHttpRequestRetryHandler(parameters.getTransferRetries(), true)).setKeepAliveStrategy(new DefaultConnectionKeepAliveStrategy(){

                @Override
                public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                    long keepAliveDuration = super.getKeepAliveDuration(response, context);
                    if (keepAliveDuration == -1L) {
                        return parameters.getMaxConnectionTtlMs().intValue();
                    }
                    return keepAliveDuration;
                }
            }).setMaxConnPerRoute(parameters.getMaxConnectionsPerRoute()).setMaxConnTotal(parameters.getMaxConnectionsTotal()).setConnectionTimeToLive(parameters.getMaxConnectionTtlMs().intValue(), TimeUnit.MILLISECONDS).evictIdleConnections(parameters.getMaxConnectionIdleTtlMs().intValue(), TimeUnit.MILLISECONDS);
            return builder.addInterceptorLast(new BearerAuthInterceptor(parameters.getApiKey())).build();
        }

        protected LockFile buildLockFile(ListenerParameters parameters) {
            return ReportPortal.getLockFile(parameters);
        }

        protected PropertiesLoader defaultPropertiesLoader() {
            return PropertiesLoader.load();
        }

        protected ExecutorService buildExecutorService(ListenerParameters params) {
            return ReportPortal.buildExecutorService(params);
        }
    }
}

