/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.launch;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.LaunchImpl;
import com.epam.reportportal.service.LaunchLoggingContext;
import com.epam.reportportal.service.LockFile;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.utils.Waiter;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.disposables.Disposable;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecondaryLaunch
extends LaunchImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(SecondaryLaunch.class);
    private final ReportPortalClient rpClient;
    private final LockFile lockFile;
    private final AtomicReference<String> instanceUuid;

    public SecondaryLaunch(ReportPortalClient rpClient, ListenerParameters parameters, Maybe<String> launch, ExecutorService executorService, LockFile lockFile, AtomicReference<String> instanceUuid) {
        super(rpClient, parameters, launch, executorService);
        this.rpClient = rpClient;
        this.lockFile = lockFile;
        this.instanceUuid = instanceUuid;
    }

    private void waitForLaunchStart() {
        new Waiter("Wait for Launch start").pollingEvery(1L, TimeUnit.SECONDS).timeoutFail().till(new Callable<Boolean>(){
            private volatile Boolean result = null;
            private final Queue<Disposable> disposables = new ConcurrentLinkedQueue<Disposable>();

            @Override
            public Boolean call() {
                if (this.result == null) {
                    this.disposables.add(SecondaryLaunch.this.launch.subscribe(uuid -> {
                        Maybe<LaunchResource> maybeRs = SecondaryLaunch.this.rpClient.getLaunchByUuid((String)uuid);
                        if (maybeRs != null) {
                            this.disposables.add(maybeRs.subscribe(launchResource -> {
                                this.result = Boolean.TRUE;
                            }, throwable -> LOGGER.debug("Unable to get a Launch: " + throwable.getLocalizedMessage(), throwable)));
                        } else {
                            LOGGER.debug("RP Client returned 'null' response on get Launch by UUID call");
                        }
                    }));
                } else {
                    Disposable disposable;
                    while ((disposable = this.disposables.poll()) != null) {
                        disposable.dispose();
                    }
                }
                return this.result;
            }
        });
    }

    @Override
    public Maybe<String> start() {
        if (!this.getParameters().isAsyncReporting()) {
            this.waitForLaunchStart();
        }
        return super.start();
    }

    @Override
    public void finish(FinishExecutionRQ rq) {
        ((LaunchImpl.TreeItem)this.QUEUE.getUnchecked(this.launch)).addToQueue(LaunchLoggingContext.complete());
        try {
            Throwable throwable = Completable.concat(((LaunchImpl.TreeItem)this.QUEUE.getUnchecked(this.launch)).getChildren()).timeout((long)this.getParameters().getReportingTimeout().intValue(), TimeUnit.SECONDS).blockingGet();
            if (throwable != null) {
                LOGGER.error("Unable to finish secondary launch in ReportPortal", throwable);
            }
        }
        finally {
            this.rpClient.close();
            this.lockFile.finishInstanceUuid(this.instanceUuid.get());
        }
    }
}

