/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.step;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.LogLevel;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.step.StepReporter;
import com.epam.reportportal.utils.files.Utils;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rp.com.google.common.base.Throwables;

public class DefaultStepReporter
implements StepReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStepReporter.class);
    private final ThreadLocal<Deque<Maybe<String>>> parents = ThreadLocal.withInitial(ArrayDeque::new);
    private final ThreadLocal<Deque<StepReporter.StepEntry>> steps = ThreadLocal.withInitial(ArrayDeque::new);
    private final Set<Maybe<String>> parentFailures = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Launch launch;

    public DefaultStepReporter(Launch currentLaunch) {
        this.launch = currentLaunch;
    }

    @Override
    public void setParent(Maybe<String> parentUuid) {
        if (parentUuid != null) {
            this.parents.get().add(parentUuid);
        }
    }

    @Override
    public Maybe<String> getParent() {
        return this.parents.get().peekLast();
    }

    @Override
    public void removeParent(Maybe<String> parentUuid) {
        if (parentUuid != null) {
            this.parents.get().removeLastOccurrence(parentUuid);
            this.parentFailures.remove(parentUuid);
        }
    }

    @Override
    public boolean isFailed(Maybe<String> parentId) {
        return this.parentFailures.contains(parentId);
    }

    protected void sendStep(ItemStatus status, String name, Runnable actions) {
        StartTestItemRQ rq = this.buildStartStepRequest(name);
        Maybe<String> stepId = this.startStepRequest(rq);
        if (actions != null) {
            try {
                actions.run();
            }
            catch (Throwable e) {
                LOGGER.error("Unable to process nested step: " + e.getLocalizedMessage(), e);
            }
        }
        this.finishStepRequest(stepId, status, rq.getStartTime());
    }

    @Override
    public void sendStep(String name) {
        this.sendStep(ItemStatus.PASSED, name, () -> {});
    }

    @Override
    public void sendStep(String name, String ... logs) {
        this.sendStep(ItemStatus.PASSED, name, logs);
    }

    @Override
    public void sendStep(@Nonnull ItemStatus status, String name) {
        this.sendStep(status, name, () -> {});
    }

    @Override
    public void sendStep(@Nonnull ItemStatus status, String name, String ... logs) {
        Runnable actions = Optional.ofNullable(logs).map(l -> () -> Arrays.stream(l).forEach(log -> ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, (String)log, LogLevel.INFO)))).orElse(null);
        this.sendStep(status, name, actions);
    }

    @Override
    public void sendStep(@Nonnull ItemStatus status, String name, Throwable throwable) {
        this.sendStep(status, name, () -> ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, throwable)));
    }

    @Override
    public void sendStep(String name, File ... files) {
        this.sendStep(ItemStatus.PASSED, name, files);
    }

    @Override
    public void sendStep(@Nonnull ItemStatus status, String name, File ... files) {
        Runnable actions = Optional.ofNullable(files).map(f -> () -> Arrays.stream(f).forEach(file -> ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, "", LogLevel.INFO, (File)file)))).orElse(null);
        this.sendStep(status, name, actions);
    }

    @Override
    public void sendStep(@Nonnull ItemStatus status, String name, Throwable throwable, File ... files) {
        this.sendStep(status, name, () -> {
            for (File file : files) {
                ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, throwable, file));
            }
        });
    }

    private Optional<StepReporter.StepEntry> finishPreviousStepInternal() {
        return Optional.ofNullable(this.steps.get().poll()).map(stepEntry -> {
            this.launch.finishTestItem(stepEntry.getItemId(), stepEntry.getFinishTestItemRQ());
            return stepEntry;
        });
    }

    @Override
    public void finishPreviousStep() {
        this.finishPreviousStepInternal().ifPresent(e -> {
            if (ItemStatus.FAILED.name().equalsIgnoreCase(e.getFinishTestItemRQ().getStatus())) {
                this.parentFailures.addAll((Collection<Maybe<String>>)this.parents.get());
            }
        });
    }

    private Maybe<String> startStepRequest(StartTestItemRQ startTestItemRQ) {
        this.finishPreviousStepInternal().ifPresent(e -> {
            Date currentDate;
            Date previousDate = e.getTimestamp();
            if (!previousDate.before(currentDate = startTestItemRQ.getStartTime())) {
                startTestItemRQ.setStartTime(new Date(previousDate.getTime() + 1L));
            }
            if (ItemStatus.FAILED.name().equalsIgnoreCase(e.getFinishTestItemRQ().getStatus())) {
                this.parentFailures.addAll((Collection<Maybe<String>>)this.parents.get());
            }
        });
        return this.launch.startTestItem(this.parents.get().getLast(), startTestItemRQ);
    }

    private StartTestItemRQ buildStartStepRequest(String name) {
        StartTestItemRQ startTestItemRQ = new StartTestItemRQ();
        startTestItemRQ.setName(name);
        startTestItemRQ.setType("STEP");
        startTestItemRQ.setHasStats(false);
        startTestItemRQ.setStartTime(Calendar.getInstance().getTime());
        return startTestItemRQ;
    }

    private void finishStepRequest(Maybe<String> stepId, ItemStatus status, Date timestamp) {
        FinishTestItemRQ finishTestItemRQ = this.buildFinishTestItemRequest(status, Calendar.getInstance().getTime());
        this.steps.get().add(new StepReporter.StepEntry(stepId, timestamp, finishTestItemRQ));
    }

    private FinishTestItemRQ buildFinishTestItemRequest(ItemStatus status, Date endTime) {
        FinishTestItemRQ finishTestItemRQ = new FinishTestItemRQ();
        finishTestItemRQ.setStatus(status.name());
        finishTestItemRQ.setEndTime(endTime);
        return finishTestItemRQ;
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, String message, LogLevel level) {
        SaveLogRQ rq = new SaveLogRQ();
        rq.setItemUuid(itemId);
        rq.setMessage(message);
        rq.setLevel(level.name());
        rq.setLogTime(Calendar.getInstance().getTime());
        return rq;
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, String message, LogLevel level, File file) {
        SaveLogRQ logRQ = this.buildSaveLogRequest(itemId, message, level);
        if (file != null) {
            try {
                logRQ.setFile(this.createFileModel(file));
            }
            catch (IOException e) {
                LOGGER.error("Unable to read file attachment: " + e.getMessage(), (Throwable)e);
            }
        }
        return logRQ;
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, Throwable throwable, File file) {
        String message = throwable != null ? Throwables.getStackTraceAsString(throwable) : "Test has failed without exception";
        return this.buildSaveLogRequest(itemId, message, LogLevel.ERROR, file);
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, Throwable throwable) {
        return this.buildSaveLogRequest(itemId, throwable, null);
    }

    private SaveLogRQ.File createFileModel(File file) throws IOException {
        TypeAwareByteSource dataSource = Utils.getFile(file);
        SaveLogRQ.File fileModel = new SaveLogRQ.File();
        fileModel.setContent(dataSource.read());
        fileModel.setContentType(dataSource.getMediaType());
        fileModel.setName(UUID.randomUUID().toString());
        return fileModel;
    }
}

