/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.tree;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ItemType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TestItemTree {
    private Maybe<String> launchId;
    private final Map<ItemTreeKey, TestItemLeaf> testItems = new ConcurrentHashMap<ItemTreeKey, TestItemLeaf>();

    public static TestItemLeaf createTestItemLeaf(Maybe<String> itemId) {
        return new TestItemLeaf((Maybe)itemId);
    }

    @Deprecated
    public static TestItemLeaf createTestItemLeaf(Maybe<String> itemId, int expectedChildrenCount) {
        return TestItemTree.createTestItemLeaf(itemId);
    }

    public static TestItemLeaf createTestItemLeaf(Maybe<String> parentId, Maybe<String> itemId) {
        return new TestItemLeaf((Maybe)parentId, (Maybe)itemId);
    }

    @Deprecated
    public static TestItemLeaf createTestItemLeaf(Maybe<String> parentId, Maybe<String> itemId, int expectedChildrenCount) {
        return TestItemTree.createTestItemLeaf(parentId, itemId);
    }

    public static TestItemLeaf createTestItemLeaf(Maybe<String> itemId, Map<ItemTreeKey, TestItemLeaf> childItems) {
        return new TestItemLeaf(itemId, Collections.emptyMap(), childItems);
    }

    public static TestItemLeaf createTestItemLeaf(Maybe<String> itemId, Map<ItemTreeKey, TestItemLeaf> childItems, Map<String, Object> attributes) {
        return new TestItemLeaf(itemId, attributes, childItems);
    }

    public static TestItemLeaf createTestItemLeaf(Maybe<String> parentId, Maybe<String> itemId, Map<ItemTreeKey, TestItemLeaf> childItems) {
        return new TestItemLeaf(parentId, itemId, Collections.emptyMap(), childItems);
    }

    public static TestItemLeaf createTestItemLeaf(Maybe<String> parentId, Maybe<String> itemId, Map<ItemTreeKey, TestItemLeaf> childItems, Map<String, Object> attributes) {
        return new TestItemLeaf(parentId, itemId, attributes, childItems);
    }

    public Maybe<String> getLaunchId() {
        return this.launchId;
    }

    public void setLaunchId(Maybe<String> launchId) {
        this.launchId = launchId;
    }

    public Map<ItemTreeKey, TestItemLeaf> getTestItems() {
        return this.testItems;
    }

    public static class TestItemLeaf {
        @Nullable
        private Maybe<String> parentId;
        @Nullable
        private Maybe<OperationCompletionRS> finishResponse;
        private final Maybe<String> itemId;
        private final Map<ItemTreeKey, TestItemLeaf> childItems = new ConcurrentHashMap<ItemTreeKey, TestItemLeaf>();
        private final Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
        private ItemStatus status;
        private ItemType type;

        private TestItemLeaf(Maybe<String> itemId) {
            this.itemId = itemId;
        }

        private TestItemLeaf(Maybe<String> itemId, Map<String, Object> attributes) {
            this(itemId);
            this.attributes.putAll(attributes);
        }

        private TestItemLeaf(Maybe<String> itemId, Map<String, Object> attributes, Map<ItemTreeKey, TestItemLeaf> childItems) {
            this(itemId, attributes);
            this.childItems.putAll(childItems);
        }

        private TestItemLeaf(@Nullable Maybe<String> parentId, Maybe<String> itemId) {
            this(itemId);
            this.parentId = parentId;
        }

        private TestItemLeaf(@Nullable Maybe<String> parentId, Maybe<String> itemId, Map<String, Object> attributes) {
            this(itemId, attributes);
            this.parentId = parentId;
        }

        private TestItemLeaf(@Nullable Maybe<String> parentId, Maybe<String> itemId, Map<String, Object> attributes, Map<ItemTreeKey, TestItemLeaf> childItems) {
            this(itemId, parentId, attributes);
            this.childItems.putAll(childItems);
        }

        @Nullable
        public Maybe<String> getParentId() {
            return this.parentId;
        }

        public void setParentId(@Nullable Maybe<String> parentId) {
            this.parentId = parentId;
        }

        @Nullable
        public Maybe<OperationCompletionRS> getFinishResponse() {
            return this.finishResponse;
        }

        public void setFinishResponse(@Nullable Maybe<OperationCompletionRS> finishResponse) {
            this.finishResponse = finishResponse;
        }

        public Maybe<String> getItemId() {
            return this.itemId;
        }

        @Nonnull
        public Map<ItemTreeKey, TestItemLeaf> getChildItems() {
            return this.childItems;
        }

        public ItemStatus getStatus() {
            return this.status;
        }

        public void setStatus(ItemStatus status) {
            this.status = status;
        }

        public ItemType getType() {
            return this.type;
        }

        public void setType(ItemType type) {
            this.type = type;
        }

        @Nullable
        public <T> T getAttribute(String key) {
            return (T)this.attributes.get(key);
        }

        @Nullable
        public Object setAttribute(String key, Object value) {
            return this.attributes.put(key, value);
        }

        @Nullable
        public Object clearAttribute(String key) {
            return this.attributes.remove(key);
        }

        public Map<String, Object> getAttributes() {
            return Collections.unmodifiableMap(this.attributes);
        }
    }

    public static final class ItemTreeKey {
        private final String name;
        private final int hash;

        private ItemTreeKey(String name, int hash) {
            this.name = name;
            this.hash = hash;
        }

        private ItemTreeKey(String name) {
            this(name, name != null ? name.hashCode() : 0);
        }

        public String getName() {
            return this.name;
        }

        public int getHash() {
            return this.hash;
        }

        public static ItemTreeKey of(String name) {
            return new ItemTreeKey(name);
        }

        public static ItemTreeKey of(String name, int hash) {
            return new ItemTreeKey(name, hash);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ItemTreeKey that = (ItemTreeKey)o;
            if (this.hash != that.hash) {
                return false;
            }
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + this.hash;
            return result;
        }
    }
}

