/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.annotations.attribute.Attribute;
import com.epam.reportportal.annotations.attribute.Attributes;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import rp.com.google.common.collect.Lists;
import rp.com.google.common.collect.Sets;

public class AttributeParser {
    public static final String ATTRIBUTES_SPLITTER = ";";
    public static final String KEY_VALUE_SPLITTER = ":";

    public static Set<ItemAttributesRQ> parseAsSet(String rawAttributes) {
        String[] attributesSplit;
        if (null == rawAttributes) {
            return Sets.newHashSet();
        }
        HashSet<ItemAttributesRQ> attributes = Sets.newHashSet();
        for (String s : attributesSplit = rawAttributes.trim().split(ATTRIBUTES_SPLITTER)) {
            ItemAttributesRQ itemAttributeResource = AttributeParser.splitKeyValue(s);
            if (itemAttributeResource == null) continue;
            attributes.add(itemAttributeResource);
        }
        return attributes;
    }

    public static ItemAttributesRQ splitKeyValue(String attribute) {
        if (null == attribute || attribute.trim().isEmpty()) {
            return null;
        }
        String[] keyValue = attribute.split(KEY_VALUE_SPLITTER);
        if (keyValue.length == 1) {
            return new ItemAttributesRQ(null, keyValue[0].trim());
        }
        if (keyValue.length == 2) {
            String key = keyValue[0].trim();
            if (key.isEmpty()) {
                key = null;
            }
            return new ItemAttributesRQ(key, keyValue[1].trim());
        }
        return null;
    }

    public static Set<ItemAttributesRQ> retrieveAttributes(Attributes attributesAnnotation) {
        LinkedHashSet<ItemAttributesRQ> itemAttributes = Sets.newLinkedHashSet();
        for (Attribute attribute : attributesAnnotation.attributes()) {
            if (attribute.value().trim().isEmpty()) continue;
            itemAttributes.add(AttributeParser.createItemAttribute(attribute.key(), attribute.value()));
        }
        for (Annotation annotation : attributesAnnotation.attributeValues()) {
            if (annotation.value().trim().isEmpty()) continue;
            itemAttributes.add(AttributeParser.createItemAttribute(null, annotation.value()));
        }
        for (Annotation annotation : attributesAnnotation.multiKeyAttributes()) {
            itemAttributes.addAll(AttributeParser.createItemAttributes(annotation.keys(), annotation.value()));
        }
        for (Annotation annotation : attributesAnnotation.multiValueAttributes()) {
            itemAttributes.addAll(AttributeParser.createItemAttributes(annotation.isNullKey() ? null : annotation.key(), annotation.values()));
        }
        return itemAttributes;
    }

    private static List<ItemAttributesRQ> createItemAttributes(String[] keys, String value) {
        if (value == null || value.trim().isEmpty()) {
            return Collections.emptyList();
        }
        if (keys == null || keys.length < 1) {
            return Collections.singletonList(AttributeParser.createItemAttribute(null, value));
        }
        ArrayList<ItemAttributesRQ> itemAttributes = Lists.newArrayListWithExpectedSize(keys.length);
        for (String key : keys) {
            itemAttributes.add(AttributeParser.createItemAttribute(key, value));
        }
        return itemAttributes;
    }

    private static List<ItemAttributesRQ> createItemAttributes(String key, String[] values) {
        if (values != null && values.length > 0) {
            ArrayList<ItemAttributesRQ> attributes = Lists.newArrayListWithExpectedSize(values.length);
            for (String value : values) {
                if (value == null || value.trim().isEmpty()) continue;
                attributes.add(AttributeParser.createItemAttribute(key, value));
            }
            return attributes;
        }
        return Collections.emptyList();
    }

    private static ItemAttributesRQ createItemAttribute(String key, String value) {
        return new ItemAttributesRQ(key, value);
    }
}

