/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import rp.com.google.common.base.Strings;
import rp.com.google.common.io.ByteSource;

public class MimeTypeDetector {
    private static final Detector detector = new AutoDetectParser().getDetector();

    private MimeTypeDetector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detect(File file) throws IOException {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", file.getName());
        TikaInputStream is = TikaInputStream.get((File)file);
        try {
            String string = MimeTypeDetector.detect(is, metadata);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detect(ByteSource source, String resourceName) throws IOException {
        Metadata metadata = new Metadata();
        if (!Strings.isNullOrEmpty(resourceName)) {
            metadata.set("resourceName", resourceName);
        }
        TikaInputStream is = TikaInputStream.get((InputStream)source.openBufferedStream());
        try {
            String string = MimeTypeDetector.detect(is, metadata);
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static String detect(TikaInputStream is, Metadata metadata) throws IOException {
        return detector.detect((InputStream)is, metadata).toString();
    }
}

