/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.properties;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.utils.properties.ListenerProperty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Supplier;
import rp.com.google.common.annotations.VisibleForTesting;
import rp.com.google.common.base.Suppliers;

public class PropertiesLoader {
    public static final String INNER_PATH = "reportportal.properties";
    public static final String PATH = "./reportportal.properties";
    public static final Charset STANDARD_CHARSET = StandardCharsets.UTF_8;
    private final Supplier<Properties> propertiesSupplier = Suppliers.memoize(propertiesSupplier::get);

    public static PropertiesLoader load() {
        return new PropertiesLoader(() -> {
            try {
                return PropertiesLoader.loadProperties(INNER_PATH);
            }
            catch (IOException e) {
                throw new InternalReportPortalClientException("Unable to load properties", e);
            }
        });
    }

    public static PropertiesLoader load(String resource) {
        return new PropertiesLoader(() -> {
            try {
                return PropertiesLoader.loadProperties(resource);
            }
            catch (IOException e) {
                throw new InternalReportPortalClientException("Unable to load properties", e);
            }
        });
    }

    private PropertiesLoader(Supplier<Properties> propertiesSupplier) {
    }

    public String getProperty(String propertyName) {
        return this.propertiesSupplier.get().getProperty(propertyName);
    }

    public String getProperty(ListenerProperty propertyName, String defaultValue) {
        String value = this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
        return value != null ? value : defaultValue;
    }

    public boolean getPropertyAsBoolean(ListenerProperty propertyName, boolean defaultValue) {
        String value = this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
        return null != value ? Boolean.parseBoolean(value) : defaultValue;
    }

    public int getPropertyAsInt(ListenerProperty propertyName, int defaultValue) {
        String value = this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
        return null != value ? Integer.parseInt(value) : defaultValue;
    }

    public String getProperty(ListenerProperty propertyName) {
        return this.propertiesSupplier.get().getProperty(propertyName.getPropertyName());
    }

    public Properties getProperties() {
        return this.propertiesSupplier.get();
    }

    public void overrideWith(Properties overrides) {
        PropertiesLoader.overrideWith(this.propertiesSupplier.get(), overrides);
    }

    private static Properties loadProperties(String resource) throws IOException {
        Properties props = new Properties();
        Optional<URL> propertyFile = PropertiesLoader.getResource(resource);
        if (propertyFile.isPresent()) {
            try (InputStream is = propertyFile.get().openStream();){
                props.load(new InputStreamReader(is, STANDARD_CHARSET));
            }
        }
        PropertiesLoader.overrideWith(props, System.getProperties());
        PropertiesLoader.overrideWith(props, System.getenv());
        return props;
    }

    @Deprecated
    private static Properties loadFromFile() throws IOException {
        Properties props = new Properties();
        File propertiesFile = new File(PATH);
        try (InputStream is = propertiesFile.exists() ? new FileInputStream(propertiesFile) : PropertiesLoader.class.getResourceAsStream(INNER_PATH);
             InputStreamReader isr = new InputStreamReader(is, STANDARD_CHARSET);){
            props.load(isr);
        }
        return props;
    }

    public void validate() {
        PropertiesLoader.validateProperties(this.getProperties());
    }

    private static void validateProperties(Properties properties) {
        for (ListenerProperty listenerProperty : ListenerProperty.values()) {
            if (!listenerProperty.isRequired() || properties.getProperty(listenerProperty.getPropertyName()) != null) continue;
            throw new IllegalArgumentException("Property '" + listenerProperty.getPropertyName() + "' should not be null.");
        }
    }

    @VisibleForTesting
    static void overrideWith(Properties source, Map<String, String> overrides) {
        Map<String, String> overridesNormalized = PropertiesLoader.normalizeOverrides(overrides);
        for (ListenerProperty listenerProperty : ListenerProperty.values()) {
            if (overridesNormalized.get(listenerProperty.getPropertyName()) == null) continue;
            source.setProperty(listenerProperty.getPropertyName(), overridesNormalized.get(listenerProperty.getPropertyName()));
        }
    }

    private static Map<String, String> normalizeOverrides(Map<String, String> overrides) {
        HashMap<String, String> normalizedSet = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : overrides.entrySet()) {
            if (entry.getKey() == null) continue;
            String key = entry.getKey().toLowerCase().replace("_", ".");
            normalizedSet.put(key, entry.getValue());
        }
        return normalizedSet;
    }

    @VisibleForTesting
    static void overrideWith(Properties source, Properties overrides) {
        PropertiesLoader.overrideWith(source, (Map<String, String>)overrides);
    }

    private static Optional<URL> getResource(String resourceName) {
        ClassLoader loader = Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElse(PropertiesLoader.class.getClassLoader());
        return Optional.ofNullable(loader.getResource(resourceName));
    }
}

