/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.LoggingCallback;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.reportportal.utils.files.ImageConverter;
import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.subjects.PublishSubject;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Function;
import rp.com.google.common.io.ByteSource;

public class LoggingContext {
    public static final int DEFAULT_BUFFER_SIZE = 10;
    static final ThreadLocal<Deque<LoggingContext>> CONTEXT_THREAD_LOCAL = ThreadLocal.withInitial(ArrayDeque::new);
    private final PublishSubject<Maybe<SaveLogRQ>> emitter;
    private final Maybe<String> launchUuid;
    private final Maybe<String> itemUuid;
    private final boolean convertImages;

    public static LoggingContext init(Maybe<String> launchUuid, Maybe<String> itemUuid, ReportPortalClient client, Scheduler scheduler) {
        return LoggingContext.init(launchUuid, itemUuid, client, scheduler, 10, false);
    }

    public static LoggingContext init(Maybe<String> launchUuid, Maybe<String> itemUuid, ReportPortalClient client, Scheduler scheduler, int bufferSize, boolean convertImages) {
        LoggingContext context = new LoggingContext(launchUuid, itemUuid, client, scheduler, bufferSize, convertImages);
        CONTEXT_THREAD_LOCAL.get().push(context);
        return context;
    }

    public static Completable complete() {
        LoggingContext loggingContext = CONTEXT_THREAD_LOCAL.get().poll();
        if (null != loggingContext) {
            return loggingContext.completed();
        }
        return Maybe.empty().ignoreElement();
    }

    LoggingContext(Maybe<String> launchUuid, Maybe<String> itemUuid, ReportPortalClient client, Scheduler scheduler, int bufferSize, boolean convertImages) {
        this.launchUuid = launchUuid;
        this.itemUuid = itemUuid;
        this.emitter = PublishSubject.create();
        this.convertImages = convertImages;
        this.emitter.toFlowable(BackpressureStrategy.BUFFER).flatMap(Maybe::toFlowable).buffer(bufferSize).flatMap(rqs -> client.log(HttpRequestUtils.buildLogMultiPartRequest(rqs)).toFlowable()).doOnError(throwable -> LoggingCallback.LOG_ERROR.accept(throwable)).observeOn(scheduler).subscribe(SubscriptionUtils.logFlowableResults("Logging context"));
    }

    public void emit(Function<String, SaveLogRQ> logSupplier) {
        this.emitter.onNext((Object)this.launchUuid.zipWith(this.itemUuid, (launchId, itemId) -> {
            SaveLogRQ rq = (SaveLogRQ)logSupplier.apply((String)itemId);
            rq.setLaunchUuid(launchId);
            SaveLogRQ.File file = rq.getFile();
            if (this.convertImages && null != file && ImageConverter.isImage(file.getContentType())) {
                TypeAwareByteSource source = ImageConverter.convert(ByteSource.wrap(file.getContent()));
                file.setContent(source.read());
                file.setContentType(source.getMediaType());
            }
            return rq;
        }));
    }

    public Completable completed() {
        this.emitter.onComplete();
        return this.emitter.ignoreElements();
    }
}

