/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.annotations.ParameterKey;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import java.lang.annotation.Annotation;
import java.lang.reflect.Executable;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;

public class ParameterUtils {
    private ParameterUtils() {
    }

    @Nonnull
    public static List<ParameterResource> getParameters(@Nonnull Executable method, List<Object> parameterValues) {
        List values = Optional.ofNullable(parameterValues).orElse(Collections.emptyList());
        Parameter[] params = method.getParameters();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        return IntStream.range(0, params.length).boxed().map(i -> {
            ParameterResource res = new ParameterResource();
            String parameterName = Arrays.stream(parameterAnnotations[i]).filter(a -> ParameterKey.class.equals(a.annotationType())).map(a -> ((ParameterKey)a).value()).findFirst().orElseGet(() -> params[i].getType().getName());
            res.setKey(parameterName);
            res.setValue(Optional.ofNullable(i < values.size() ? (Object)values.get((int)i) : null).orElse("NULL").toString());
            return res;
        }).collect(Collectors.toList());
    }

    public static Class<?> toBoxedType(@Nonnull Class<?> primitiveType) {
        if (primitiveType.isPrimitive()) {
            if (primitiveType == Boolean.TYPE) {
                return Boolean.class;
            }
            if (primitiveType == Byte.TYPE) {
                return Byte.class;
            }
            if (primitiveType == Character.TYPE) {
                return Character.class;
            }
            if (primitiveType == Short.TYPE) {
                return Short.class;
            }
            if (primitiveType == Integer.TYPE) {
                return Integer.class;
            }
            if (primitiveType == Long.TYPE) {
                return Long.class;
            }
            if (primitiveType == Float.TYPE) {
                return Float.class;
            }
            if (primitiveType == Double.TYPE) {
                return Double.class;
            }
            if (primitiveType == Void.TYPE) {
                return Void.class;
            }
            return null;
        }
        return primitiveType;
    }
}

