/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.annotations.StepTemplateConfig;
import com.epam.reportportal.utils.reflect.Accessible;
import java.lang.reflect.Array;
import java.util.Iterator;

public class StepTemplateUtils {
    private static final String NULL_VALUE = "NULL";

    private StepTemplateUtils() {
    }

    public static String retrieveValue(StepTemplateConfig templateConfig, int index, String[] fields, Object object) throws NoSuchFieldException {
        if (object == null) {
            return NULL_VALUE;
        }
        for (int i = index; i < fields.length; ++i) {
            if (object.getClass().isArray()) {
                return StepTemplateUtils.parseArray(templateConfig, (Object[])object, i, fields);
            }
            if (object instanceof Iterable) {
                return StepTemplateUtils.parseCollection(templateConfig, (Iterable)object, i, fields);
            }
            object = Accessible.on(object).field(fields[i]).getValue();
        }
        return StepTemplateUtils.parseDescendant(templateConfig, object);
    }

    private static String parseArray(StepTemplateConfig templateConfig, Object[] array, int index, String[] fields) throws NoSuchFieldException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(templateConfig.arrayStartSymbol());
        for (int i = 0; i < array.length; ++i) {
            stringBuilder.append(StepTemplateUtils.retrieveValue(templateConfig, index, fields, array[i]));
            if (i >= array.length - 1) continue;
            stringBuilder.append(templateConfig.arrayElementDelimiter());
        }
        stringBuilder.append(templateConfig.arrayEndSymbol());
        return stringBuilder.toString();
    }

    private static String parseCollection(StepTemplateConfig templateConfig, Iterable iterable, int index, String[] fields) throws NoSuchFieldException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(templateConfig.iterableStartSymbol());
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(StepTemplateUtils.retrieveValue(templateConfig, index, fields, iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(templateConfig.iterableElementDelimiter());
        }
        stringBuilder.append(templateConfig.iterableEndSymbol());
        return stringBuilder.toString();
    }

    private static String parseDescendant(StepTemplateConfig templateConfig, Object descendant) {
        if (descendant.getClass().isArray()) {
            return StepTemplateUtils.parseDescendantArray(templateConfig, descendant);
        }
        if (descendant instanceof Iterable) {
            return StepTemplateUtils.parseDescendantCollection(templateConfig, (Iterable)descendant);
        }
        return String.valueOf(descendant);
    }

    private static String parseDescendantArray(StepTemplateConfig templateConfig, Object array) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(templateConfig.arrayStartSymbol());
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(StepTemplateUtils.parseDescendant(templateConfig, Array.get(array, i)));
            if (i >= length - 1) continue;
            stringBuilder.append(templateConfig.arrayElementDelimiter());
        }
        stringBuilder.append(templateConfig.arrayEndSymbol());
        return stringBuilder.toString();
    }

    private static String parseDescendantCollection(StepTemplateConfig templateConfig, Iterable iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(templateConfig.iterableStartSymbol());
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(StepTemplateUtils.parseDescendant(templateConfig, iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(templateConfig.iterableElementDelimiter());
        }
        stringBuilder.append(templateConfig.iterableEndSymbol());
        return stringBuilder.toString();
    }
}

