/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.exception;

import com.epam.reportportal.exception.GeneralReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorRS;
import org.apache.commons.lang3.StringUtils;
import rp.com.google.common.annotations.VisibleForTesting;

public class ReportPortalException
extends GeneralReportPortalException {
    private static final int MAX_ERROR_MESSAGE_LENGTH = 100000;
    private static final long serialVersionUID = -3747137063782963453L;
    protected final ErrorRS error;

    public ReportPortalException(int statusCode, String statusMessage, ErrorRS error) {
        super(statusCode, statusMessage, error.getMessage());
        this.error = error;
    }

    public ErrorRS getError() {
        return this.error;
    }

    @Override
    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append("Report Portal returned error\n").append("Status code: ").append(this.statusCode).append("\n").append("Status message: ").append(this.statusMessage).append("\n");
        if (null != this.error) {
            builder.append("Error Message: ").append(ReportPortalException.trimMessage(this.error.getMessage(), 100000)).append("\n").append("Error Type: ").append(this.error.getErrorType()).append("\n");
        }
        return builder.toString();
    }

    @VisibleForTesting
    static String trimMessage(String message, int maxLength) {
        if (StringUtils.isBlank((CharSequence)message)) {
            return "";
        }
        if (message.length() > maxLength) {
            return message.substring(0, maxLength);
        }
        return message;
    }
}

