/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.analytics;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.analytics.Analytics;
import com.epam.reportportal.service.analytics.DummyAnalytics;
import com.epam.reportportal.service.analytics.Statistics;
import com.epam.reportportal.service.analytics.item.AnalyticsEvent;
import com.epam.reportportal.utils.properties.ClientProperties;
import com.epam.reportportal.utils.properties.DefaultProperties;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import rp.com.google.common.util.concurrent.ThreadFactoryBuilder;

public class AnalyticsService
implements Closeable {
    public static final String ANALYTICS_PROPERTY = "AGENT_NO_ANALYTICS";
    private static final String CLIENT_PROPERTIES_FILE = "client.properties";
    private static final String START_LAUNCH_EVENT_ACTION = "Start launch";
    private static final String CLIENT_VALUE_FORMAT = "Client name \"%s\", version \"%s\"";
    private static final String AGENT_VALUE_FORMAT = "Agent name \"%s\", version \"%s\"";
    private final ExecutorService googleAnalyticsExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("rp-stat-%s").setDaemon(true).build());
    private final Scheduler scheduler = Schedulers.from((Executor)this.googleAnalyticsExecutor);
    private final Analytics analytics;
    private final List<Completable> dependencies = new CopyOnWriteArrayList<Completable>();
    private final ListenerParameters parameters;

    public AnalyticsService(ListenerParameters listenerParameters) {
        this.parameters = listenerParameters;
        boolean isDisabled = System.getenv(ANALYTICS_PROPERTY) != null;
        this.analytics = isDisabled ? new DummyAnalytics() : new Statistics("UA-173456809-1", this.parameters.getProxyUrl());
    }

    protected Analytics getAnalytics() {
        return this.analytics;
    }

    public void sendEvent(Maybe<String> launchIdMaybe, StartLaunchRQ rq) {
        AnalyticsEvent.AnalyticsEventBuilder analyticsEventBuilder = AnalyticsEvent.builder().withAction(START_LAUNCH_EVENT_ACTION);
        SystemAttributesExtractor.extract(CLIENT_PROPERTIES_FILE, this.getClass().getClassLoader(), ClientProperties.CLIENT).stream().map(ItemAttributeResource::getValue).map(a -> a.split(Pattern.quote("|"))).filter(a -> ((String[])a).length >= 2).findFirst().ifPresent(clientAttribute -> analyticsEventBuilder.withCategory(String.format(CLIENT_VALUE_FORMAT, clientAttribute)));
        Optional.ofNullable(rq.getAttributes()).flatMap(r -> r.stream().filter(attribute -> attribute.isSystem() && DefaultProperties.AGENT.getName().equalsIgnoreCase(attribute.getKey())).findAny()).map(ItemAttributeResource::getValue).map(a -> a.split(Pattern.quote("|"))).filter(a -> ((String[])a).length >= 2).ifPresent(agentAttribute -> analyticsEventBuilder.withLabel(String.format(AGENT_VALUE_FORMAT, agentAttribute)));
        Maybe analyticsMaybe = launchIdMaybe.map(l -> this.getAnalytics().send(analyticsEventBuilder.build())).cache().subscribeOn(this.scheduler);
        this.dependencies.add(analyticsMaybe.ignoreElement());
        analyticsMaybe.subscribe(t -> {});
    }

    @Override
    public void close() {
        try {
            Throwable result = Completable.concat(this.dependencies).timeout((long)this.parameters.getReportingTimeout().intValue(), TimeUnit.SECONDS).blockingGet();
            if (result != null) {
                throw new RuntimeException("Unable to complete execution of all dependencies", result);
            }
        }
        finally {
            this.googleAnalyticsExecutor.shutdown();
            try {
                if (!this.googleAnalyticsExecutor.awaitTermination(this.parameters.getReportingTimeout().intValue(), TimeUnit.SECONDS)) {
                    this.googleAnalyticsExecutor.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {}
            try {
                this.getAnalytics().close();
            }
            catch (IOException iOException) {}
        }
    }
}

