/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.annotations.TestCaseId;
import com.epam.reportportal.annotations.TestCaseIdKey;
import com.epam.reportportal.service.item.TestCaseIdEntry;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TestCaseIdUtils {
    private static final Function<List<Object>, String> TRANSFORM_PARAMETERS = it -> it.stream().map(String::valueOf).collect(Collectors.joining(",", "[", "]"));

    private TestCaseIdUtils() {
    }

    public static String getCodeRef(@Nonnull Method method) {
        return method.getDeclaringClass().getCanonicalName() + "." + method.getName();
    }

    @Nullable
    public static String getParametersForTestCaseId(Method method, List<Object> parameters) {
        if (method == null || parameters == null || parameters.isEmpty()) {
            return null;
        }
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (int paramIndex = 0; paramIndex < parameterAnnotations.length; ++paramIndex) {
            for (int annotationIndex = 0; annotationIndex < parameterAnnotations[paramIndex].length; ++annotationIndex) {
                Annotation testCaseIdAnnotation = parameterAnnotations[paramIndex][annotationIndex];
                if (testCaseIdAnnotation.annotationType() != TestCaseIdKey.class) continue;
                keys.add(paramIndex);
            }
        }
        if (keys.isEmpty()) {
            return TRANSFORM_PARAMETERS.apply(parameters);
        }
        if (keys.size() <= 1) {
            return String.valueOf(parameters.get((Integer)keys.get(0)));
        }
        return TRANSFORM_PARAMETERS.apply(keys.stream().map(parameters::get).collect(Collectors.toList()));
    }

    public static TestCaseIdEntry getTestCaseId(@Nullable TestCaseId annotation, @Nullable Method method, @Nullable List<Object> parameters) {
        return TestCaseIdUtils.getTestCaseId(annotation, method, null, parameters);
    }

    public static TestCaseIdEntry getTestCaseId(@Nullable TestCaseId annotation, @Nullable Method method, @Nullable String codRef, @Nullable List<Object> parameters) {
        if (annotation != null) {
            if (annotation.value().isEmpty()) {
                if (annotation.parametrized()) {
                    return Optional.ofNullable(TestCaseIdUtils.getParametersForTestCaseId(method, parameters)).map(TestCaseIdEntry::new).orElse(Optional.ofNullable(codRef).map(c -> TestCaseIdUtils.getTestCaseId(c, parameters)).orElse(TestCaseIdUtils.getTestCaseId(method, parameters)));
                }
                return Optional.ofNullable(codRef).map(c -> TestCaseIdUtils.getTestCaseId(c, parameters)).orElse(TestCaseIdUtils.getTestCaseId(method, parameters));
            }
            if (annotation.parametrized()) {
                return Optional.ofNullable(TestCaseIdUtils.getParametersForTestCaseId(method, parameters)).map(p -> new TestCaseIdEntry(annotation.value() + (p.startsWith("[") ? p : "[" + p + "]"))).orElse(Optional.ofNullable(codRef).map(c -> TestCaseIdUtils.getTestCaseId(c, parameters)).orElse(TestCaseIdUtils.getTestCaseId(method, parameters)));
            }
            return new TestCaseIdEntry(annotation.value());
        }
        return Optional.ofNullable(codRef).map(c -> TestCaseIdUtils.getTestCaseId(c, parameters)).orElse(TestCaseIdUtils.getTestCaseId(method, parameters));
    }

    public static TestCaseIdEntry getTestCaseId(@Nullable Method method, @Nullable List<Object> parameters) {
        return Optional.ofNullable(method).map(m -> TestCaseIdUtils.getTestCaseId(TestCaseIdUtils.getCodeRef(m), parameters)).orElse(TestCaseIdUtils.getTestCaseId(parameters));
    }

    public static TestCaseIdEntry getTestCaseId(@Nullable String codeRef, @Nullable List<Object> parameters) {
        return Optional.ofNullable(codeRef).map(r -> new TestCaseIdEntry(codeRef + Optional.ofNullable(parameters).map(TRANSFORM_PARAMETERS).orElse(""))).orElse(TestCaseIdUtils.getTestCaseId(parameters));
    }

    public static TestCaseIdEntry getTestCaseId(@Nullable List<Object> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        return new TestCaseIdEntry(TRANSFORM_PARAMETERS.apply(parameters));
    }
}

