/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.launch;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.LaunchIdLock;
import com.epam.reportportal.service.LaunchImpl;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.reactivex.Maybe;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class AbstractJoinedLaunch
extends LaunchImpl {
    final LaunchIdLock lock;
    volatile String uuid;
    private final ScheduledExecutorService updater = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("rp-poll").setDaemon(true).build());
    private final ScheduledFuture<?> updateTask;

    private static ScheduledFuture<?> getUpdateTask(String instanceUuid, long updateInterval, LaunchIdLock launchIdLock, ScheduledExecutorService service) {
        Random r = new Random();
        int delay = updateInterval > Integer.MAX_VALUE ? r.nextInt(Integer.MAX_VALUE) : r.nextInt((int)updateInterval);
        return service.scheduleWithFixedDelay(() -> launchIdLock.updateInstanceUuid(instanceUuid), delay, updateInterval, TimeUnit.MILLISECONDS);
    }

    public AbstractJoinedLaunch(ReportPortalClient rpClient, ListenerParameters parameters, StartLaunchRQ launch, ExecutorService executorService, LaunchIdLock launchIdLock, String instanceUuid) {
        super(rpClient, parameters, launch, executorService);
        this.lock = launchIdLock;
        this.uuid = instanceUuid;
        this.updateTask = AbstractJoinedLaunch.getUpdateTask(instanceUuid, parameters.getLockWaitTimeout(), launchIdLock, this.updater);
    }

    public AbstractJoinedLaunch(ReportPortalClient rpClient, ListenerParameters parameters, Maybe<String> launch, ExecutorService executorService, LaunchIdLock launchIdLock, String instanceUuid) {
        super(rpClient, parameters, launch, executorService);
        this.lock = launchIdLock;
        this.uuid = instanceUuid;
        this.updateTask = AbstractJoinedLaunch.getUpdateTask(instanceUuid, parameters.getLockWaitTimeout(), launchIdLock, this.updater);
    }

    void stopRunning() {
        this.updateTask.cancel(false);
        this.updater.shutdown();
    }
}

