/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.statistics;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.statistics.Statistics;
import com.epam.reportportal.service.statistics.StatisticsApiClient;
import com.epam.reportportal.service.statistics.item.StatisticsItem;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.StringUtils;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class StatisticsClient
implements Statistics {
    private static final String BASE_URL = "https://www.google-analytics.com/";
    private static final String CLIENT_ID_PROPERTY = "client.id";
    private static final String USER_AGENT = "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36";
    private static final Map<String, String> CONSTANT_REQUEST_PARAMS = ImmutableMap.builder().put((Object)"de", (Object)"UTF-8").put((Object)"v", (Object)"1").build();
    private static final Path LOCAL_DATA_STORAGE = Paths.get(System.getProperty("user.home"), ".rp", "rp.properties");
    private static final String CLIENT_ID = StatisticsClient.getClientId();
    private final Map<String, String> commonParameters;
    private final StatisticsApiClient client;
    private OkHttpClient httpClient;
    private ExecutorService executor;

    private static String getClientId() {
        Properties properties = new Properties();
        if (Files.exists(LOCAL_DATA_STORAGE, new LinkOption[0])) {
            try {
                properties.load(Files.newInputStream(LOCAL_DATA_STORAGE, StandardOpenOption.READ));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String storedId = properties.getProperty(CLIENT_ID_PROPERTY);
            if (storedId != null) {
                return storedId;
            }
        }
        String id = UUID.randomUUID().toString();
        properties.setProperty(CLIENT_ID_PROPERTY, id);
        try {
            Path folder = LOCAL_DATA_STORAGE.getParent();
            Files.createDirectories(folder, new FileAttribute[0]);
            properties.store(Files.newOutputStream(LOCAL_DATA_STORAGE, StandardOpenOption.CREATE), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return id;
    }

    private static OkHttpClient buildHttpClient(ListenerParameters parameters) {
        OkHttpClient.Builder okHttpClient = new OkHttpClient.Builder();
        String proxyStr = parameters.getProxyUrl();
        if (StringUtils.isNotBlank((CharSequence)proxyStr)) {
            try {
                URL proxyUrl = new URL(proxyStr);
                String host = proxyUrl.getHost();
                int port = proxyUrl.getPort();
                InetSocketAddress address = InetSocketAddress.createUnresolved(host, port >= 0 ? port : proxyUrl.getDefaultPort());
                okHttpClient.proxy(new Proxy(Proxy.Type.HTTP, address));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        okHttpClient.retryOnConnectionFailure(true);
        return okHttpClient.build();
    }

    private static StatisticsApiClient buildClient(OkHttpClient httpClient, Scheduler scheduler) {
        RxJava2CallAdapterFactory rxFactory = RxJava2CallAdapterFactory.createWithScheduler((Scheduler)scheduler);
        Retrofit retrofit = new Retrofit.Builder().baseUrl(BASE_URL).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).addCallAdapterFactory((CallAdapter.Factory)rxFactory).client(httpClient).build();
        return (StatisticsApiClient)retrofit.create(StatisticsApiClient.class);
    }

    private static Map<String, String> buildParams(String trackingId) {
        return ImmutableMap.builder().putAll(CONSTANT_REQUEST_PARAMS).put((Object)"cid", (Object)CLIENT_ID).put((Object)"uid", (Object)UUID.randomUUID().toString()).put((Object)"tid", (Object)trackingId).build();
    }

    public StatisticsClient(String trackingId, ListenerParameters parameters) {
        this.commonParameters = StatisticsClient.buildParams(trackingId);
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("rp-stat-%s").setDaemon(true).build());
        this.httpClient = StatisticsClient.buildHttpClient(parameters);
        this.client = StatisticsClient.buildClient(this.httpClient, Schedulers.from((Executor)this.executor));
    }

    public StatisticsClient(String trackingId, StatisticsApiClient statisticsApiClient) {
        this.commonParameters = StatisticsClient.buildParams(trackingId);
        this.client = statisticsApiClient;
    }

    @Override
    public Maybe<Response<ResponseBody>> send(StatisticsItem item) {
        return this.client.send(USER_AGENT, this.buildPostRequest(item));
    }

    private Map<String, String> buildPostRequest(StatisticsItem item) {
        HashMap<String, String> nameValuePairs = new HashMap<String, String>(item.getParams());
        nameValuePairs.putAll(this.commonParameters);
        return nameValuePairs;
    }

    @Override
    public void close() {
        Optional.ofNullable(this.httpClient).ifPresent(c -> {
            ExecutorService e = c.dispatcher().executorService();
            e.shutdown();
            try {
                if (!e.awaitTermination(10L, TimeUnit.SECONDS)) {
                    e.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            c.connectionPool().evictAll();
        });
        this.httpClient = null;
        Optional.ofNullable(this.executor).ifPresent(ExecutorService::shutdownNow);
        this.executor = null;
    }
}

