/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.http;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.utils.MimeTypeDetector;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpRequestUtils.class);
    public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String DEFAULT_TYPE = "application/octet-stream";

    private HttpRequestUtils() {
    }

    public static List<MultipartBody.Part> buildLogMultiPartRequest(List<SaveLogRQ> rqs) {
        ArrayList<MultipartBody.Part> result = new ArrayList<MultipartBody.Part>();
        try {
            result.add(MultipartBody.Part.createFormData((String)"json_request_part", null, (RequestBody)RequestBody.create((MediaType)MediaType.get((String)"application/json; charset=utf-8"), (String)MAPPER.writerFor((TypeReference)new TypeReference<List<SaveLogRQ>>(){}).writeValueAsString(rqs))));
        }
        catch (JsonProcessingException e) {
            throw new InternalReportPortalClientException("Unable to process JSON", e);
        }
        for (SaveLogRQ rq : rqs) {
            MediaType type;
            SaveLogRQ.File file = rq.getFile();
            if (null == file) continue;
            try {
                type = StringUtils.isBlank((CharSequence)file.getContentType()) ? MediaType.get((String)MimeTypeDetector.detect(ByteSource.wrap((byte[])file.getContent()), file.getName())) : MediaType.get((String)file.getContentType());
            }
            catch (IOException | IllegalArgumentException e) {
                LOGGER.error("Unable to parse content media type, default value was used: application/octet-stream", (Throwable)e);
                type = MediaType.get((String)DEFAULT_TYPE);
            }
            result.add(MultipartBody.Part.createFormData((String)"binary_part", (String)file.getName(), (RequestBody)RequestBody.create((MediaType)type, (byte[])file.getContent())));
        }
        return result;
    }

    static {
        MAPPER.setDateFormat((DateFormat)new SimpleDateFormat(DEFAULT_DATE_FORMAT));
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

