/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.statistics;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.statistics.DummyClient;
import com.epam.reportportal.service.statistics.Statistics;
import com.epam.reportportal.service.statistics.StatisticsClient;
import com.epam.reportportal.service.statistics.item.StatisticsEvent;
import com.epam.reportportal.service.statistics.item.StatisticsItem;
import com.epam.reportportal.utils.properties.ClientProperties;
import com.epam.reportportal.utils.properties.DefaultProperties;
import com.epam.reportportal.utils.properties.SystemAttributesExtractor;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributeResource;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import okhttp3.ResponseBody;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsService
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsService.class);
    private static final String CLIENT_INFO = "Ry1XUDU3UlNHOFhMOjUxREVTTzQ4UV9DbmlnbVEwY2JoYmc=";
    private static final String[] DECODED_CLIENT_INFO = new String(Base64.getDecoder().decode("Ry1XUDU3UlNHOFhMOjUxREVTTzQ4UV9DbmlnbVEwY2JoYmc="), StandardCharsets.UTF_8).split(":");
    public static final String DISABLE_PROPERTY = "AGENT_NO_ANALYTICS";
    private static final String CLIENT_PROPERTIES_FILE = "client.properties";
    public static final String START_LAUNCH_EVENT_ACTION = "start_launch";
    public static final String CLIENT_NAME_PARAM = "client_name";
    public static final String CLIENT_VERSION_PARAM = "client_version";
    public static final String INTERPRETER_PARAM = "interpreter";
    public static final String INTERPRETER_FORMAT = "Java %s";
    public static final String AGENT_NAME_PARAM = "agent_name";
    public static final String AGENT_VERSION_PARAM = "agent_version";
    private static final String CLIENT_ID_PROPERTY = "client.id";
    private static final Path LOCAL_DATA_STORAGE = Paths.get(System.getProperty("user.home"), ".rp", "rp.properties");
    private static final String CLIENT_ID = StatisticsService.getClientId();
    private static final AtomicLong THREAD_COUNTER = new AtomicLong();
    private static final ThreadFactory THREAD_FACTORY = r -> {
        Thread t = new Thread(r);
        t.setDaemon(true);
        t.setName("rp-stat-" + THREAD_COUNTER.incrementAndGet());
        return t;
    };
    private final ExecutorService statisticsExecutor = Executors.newSingleThreadExecutor(THREAD_FACTORY);
    private final Scheduler scheduler = Schedulers.from((Executor)this.statisticsExecutor);
    private final Statistics statistics;
    private final List<Completable> dependencies = new CopyOnWriteArrayList<Completable>();
    private final ListenerParameters parameters;

    private static String getClientId() {
        Properties properties = new Properties();
        if (Files.exists(LOCAL_DATA_STORAGE, new LinkOption[0])) {
            try {
                properties.load(Files.newInputStream(LOCAL_DATA_STORAGE, StandardOpenOption.READ));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String storedId = properties.getProperty(CLIENT_ID_PROPERTY);
            if (storedId != null) {
                return storedId;
            }
        }
        String id = UUID.randomUUID().toString();
        properties.setProperty(CLIENT_ID_PROPERTY, id);
        try {
            Path folder = LOCAL_DATA_STORAGE.getParent();
            Files.createDirectories(folder, new FileAttribute[0]);
            properties.store(Files.newOutputStream(LOCAL_DATA_STORAGE, StandardOpenOption.CREATE), null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return id;
    }

    public StatisticsService(ListenerParameters listenerParameters, Statistics client) {
        this.parameters = listenerParameters;
        this.statistics = client;
    }

    public StatisticsService(ListenerParameters listenerParameters) {
        this(listenerParameters, System.getenv(DISABLE_PROPERTY) != null ? new DummyClient() : new StatisticsClient(DECODED_CLIENT_INFO[0], DECODED_CLIENT_INFO[1], listenerParameters));
    }

    protected Statistics getStatistics() {
        return this.statistics;
    }

    public void sendEvent(Maybe<String> launchIdMaybe, StartLaunchRQ rq) {
        StatisticsEvent event = new StatisticsEvent(START_LAUNCH_EVENT_ACTION);
        SystemAttributesExtractor.extract(CLIENT_PROPERTIES_FILE, this.getClass().getClassLoader(), ClientProperties.CLIENT).stream().map(ItemAttributeResource::getValue).map(a -> a.split(Pattern.quote("|"))).filter(a -> ((String[])a).length >= 2).flatMap(a -> Stream.of(Pair.of((Object)CLIENT_NAME_PARAM, (Object)a[0]), Pair.of((Object)CLIENT_VERSION_PARAM, (Object)a[1]), Pair.of((Object)INTERPRETER_PARAM, (Object)String.format(INTERPRETER_FORMAT, System.getProperty("java.version"))))).forEach(p -> event.addParam((String)p.getKey(), p.getValue()));
        Optional.ofNullable(rq.getAttributes()).flatMap(r -> r.stream().filter(attribute -> attribute.isSystem() && DefaultProperties.AGENT.getName().equalsIgnoreCase(attribute.getKey())).findAny()).map(ItemAttributeResource::getValue).map(a -> a.split(Pattern.quote("|"))).filter(a -> ((String[])a).length >= 2).ifPresent(a -> Stream.of(Pair.of((Object)AGENT_NAME_PARAM, (Object)a[0]), Pair.of((Object)AGENT_VERSION_PARAM, (Object)a[1])).forEach(p -> event.addParam((String)p.getKey(), p.getValue())));
        Maybe statisticsMaybe = launchIdMaybe.flatMap(l -> this.getStatistics().send(new StatisticsItem(CLIENT_ID).addEvent(event))).cache().subscribeOn(this.scheduler);
        this.dependencies.add(statisticsMaybe.ignoreElement());
        statisticsMaybe.subscribe(t -> {
            Optional.ofNullable(t.body()).ifPresent(ResponseBody::close);
            this.getStatistics().close();
        }, t -> {
            LOGGER.error("Unable to send statistics", t);
            this.getStatistics().close();
        });
    }

    @Override
    public void close() {
        Throwable result = Completable.concat(this.dependencies).timeout((long)this.parameters.getReportingTimeout().intValue(), TimeUnit.SECONDS).blockingGet();
        if (result != null) {
            LOGGER.warn("Unable to complete execution of all dependencies", result);
        }
        this.statisticsExecutor.shutdown();
        try {
            if (!this.statisticsExecutor.awaitTermination(this.parameters.getReportingTimeout().intValue(), TimeUnit.SECONDS)) {
                this.statisticsExecutor.shutdownNow();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.getStatistics().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

