/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.exception.ReportPortalException;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.LaunchLoggingContext;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.logs.LaunchLoggingCallback;
import com.epam.reportportal.service.statistics.StatisticsService;
import com.epam.reportportal.utils.ObjectUtils;
import com.epam.reportportal.utils.RetryWithDelay;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.reportportal.utils.properties.DefaultProperties;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.item.ItemCreatedRS;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Scheduler;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class LaunchImpl
extends Launch {
    private static final Map<ExecutorService, Scheduler> SCHEDULERS = new ConcurrentHashMap<ExecutorService, Scheduler>();
    private static final Function<ItemCreatedRS, String> TO_ID = EntryCreatedAsyncRS::getId;
    private static final Consumer<StartLaunchRS> LAUNCH_SUCCESS_CONSUMER = rs -> {
        LaunchLoggingCallback.logCreated("launch").accept(rs);
        System.setProperty("rp.launch.id", String.valueOf(rs.getId()));
    };
    private static final int DEFAULT_RETRY_COUNT = 5;
    private static final int DEFAULT_RETRY_TIMEOUT = 2;
    private static final int ITEM_FINISH_MAX_RETRIES = 10;
    private static final int ITEM_FINISH_RETRY_TIMEOUT = 10;
    private static final Predicate<Throwable> INTERNAL_CLIENT_EXCEPTION_PREDICATE = throwable -> throwable instanceof InternalReportPortalClientException;
    private static final Predicate<Throwable> TEST_ITEM_FINISH_RETRY_PREDICATE = throwable -> throwable instanceof ReportPortalException && ErrorType.FINISH_ITEM_NOT_ALLOWED.equals((Object)((ReportPortalException)throwable).getError().getErrorType()) || INTERNAL_CLIENT_EXCEPTION_PREDICATE.test(throwable);
    private static final RetryWithDelay DEFAULT_REQUEST_RETRY = new RetryWithDelay(INTERNAL_CLIENT_EXCEPTION_PREDICATE, 5L, TimeUnit.SECONDS.toMillis(2L));
    private static final RetryWithDelay TEST_ITEM_FINISH_REQUEST_RETRY = new RetryWithDelay(TEST_ITEM_FINISH_RETRY_PREDICATE, 10L, TimeUnit.SECONDS.toMillis(10L));
    @Deprecated
    public static final String NOT_ISSUE = "NOT_ISSUE";
    public static final String CUSTOM_AGENT = "CUSTOM";
    protected final LoadingCache<Maybe<String>, TreeItem> QUEUE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Maybe<String>, TreeItem>(){

        public TreeItem load(@Nonnull Maybe<String> key) {
            return new TreeItem();
        }
    });
    protected final Maybe<String> launch;
    private final ExecutorService executor;
    private final Scheduler scheduler;
    private StatisticsService statisticsService;
    private final StartLaunchRQ startRq;

    protected LaunchImpl(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters parameters, @Nonnull StartLaunchRQ rq, @Nonnull ExecutorService executorService) {
        super(reportPortalClient, parameters);
        Objects.requireNonNull(parameters, "Parameters shouldn't be NULL");
        this.executor = Objects.requireNonNull(executorService);
        this.scheduler = this.createScheduler(this.executor);
        this.statisticsService = new StatisticsService(parameters);
        this.startRq = ObjectUtils.clonePojo(rq, StartLaunchRQ.class);
        LOGGER.info("Rerun: {}", (Object)parameters.isRerun());
        this.launch = Maybe.create(emitter -> {
            Maybe launchPromise = Maybe.defer(() -> {
                this.truncateAttributes((StartRQ)this.startRq);
                return this.getClient().startLaunch(this.startRq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LAUNCH_SUCCESS_CONSUMER).doOnError(LaunchLoggingCallback.LOG_ERROR);
            }).subscribeOn(this.getScheduler()).cache();
            launchPromise.subscribe(rs -> emitter.onSuccess((Object)rs.getId()), t -> {
                LaunchLoggingCallback.LOG_ERROR.accept(t);
                emitter.onComplete();
            });
        }).cache();
    }

    protected LaunchImpl(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters parameters, @Nonnull Maybe<String> launchMaybe, @Nonnull ExecutorService executorService) {
        super(reportPortalClient, parameters);
        Objects.requireNonNull(parameters, "Parameters shouldn't be NULL");
        this.executor = Objects.requireNonNull(executorService);
        this.scheduler = this.createScheduler(this.executor);
        this.statisticsService = new StatisticsService(parameters);
        this.startRq = LaunchImpl.emptyStartLaunchForStatistics();
        LOGGER.info("Rerun: {}", (Object)parameters.isRerun());
        this.launch = launchMaybe.cache();
    }

    private static StartLaunchRQ emptyStartLaunchForStatistics() {
        StartLaunchRQ result = new StartLaunchRQ();
        result.setAttributes(Collections.singleton(new ItemAttributesRQ(DefaultProperties.AGENT.getName(), CUSTOM_AGENT, true)));
        return result;
    }

    protected Scheduler createScheduler(ExecutorService executorService) {
        return SCHEDULERS.computeIfAbsent(executorService, Schedulers::from);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    @Nonnull
    public Maybe<String> getLaunch() {
        return this.launch;
    }

    StatisticsService getStatisticsService() {
        return this.statisticsService;
    }

    private void truncateName(@Nonnull StartTestItemRQ rq) {
        if (!this.getParameters().isTruncateFields() || rq.getName() == null || rq.getName().isEmpty()) {
            return;
        }
        String name = rq.getName();
        int limit = this.getParameters().getTruncateItemNamesLimit();
        String replacement = this.getParameters().getTruncateReplacement();
        if (name.length() > limit && name.length() > replacement.length()) {
            rq.setName(name.substring(0, limit - replacement.length()) + replacement);
        }
    }

    @Nullable
    private Set<ItemAttributesRQ> truncateAttributes(@Nullable Set<ItemAttributesRQ> attributes) {
        if (!this.getParameters().isTruncateFields() || attributes == null || attributes.isEmpty()) {
            return attributes;
        }
        int limit = this.getParameters().getAttributeLengthLimit();
        String replacement = this.getParameters().getTruncateReplacement();
        return attributes.stream().map(attribute -> {
            int valueLength;
            ItemAttributesRQ updated = attribute;
            int keyLength = Optional.ofNullable(updated.getKey()).map(String::length).orElse(0);
            if (keyLength > limit && keyLength > replacement.length()) {
                updated = new ItemAttributesRQ(updated.getKey().substring(0, limit - replacement.length()) + replacement, updated.getValue(), updated.isSystem());
            }
            if ((valueLength = Optional.ofNullable(updated.getValue()).map(String::length).orElse(0).intValue()) > limit && valueLength > replacement.length()) {
                updated = new ItemAttributesRQ(updated.getKey(), updated.getValue().substring(0, limit - replacement.length()) + replacement, updated.isSystem());
            }
            return updated;
        }).collect(Collectors.toSet());
    }

    private void truncateAttributes(@Nonnull StartRQ rq) {
        rq.setAttributes(this.truncateAttributes(rq.getAttributes()));
    }

    private void truncateAttributes(@Nonnull FinishExecutionRQ rq) {
        rq.setAttributes(this.truncateAttributes(rq.getAttributes()));
    }

    @Override
    @Nonnull
    public Maybe<String> start() {
        this.launch.subscribe(SubscriptionUtils.logMaybeResults("Launch start"));
        LaunchLoggingContext.init(this.launch, this.getClient(), this.getScheduler(), this.getParameters());
        this.getStatisticsService().sendEvent(this.launch, this.startRq);
        return this.launch;
    }

    @Override
    public void finish(FinishExecutionRQ request) {
        Throwable error;
        ((TreeItem)this.QUEUE.getUnchecked(this.launch)).addToQueue(LaunchLoggingContext.complete());
        Completable finish = Completable.concat(((TreeItem)this.QUEUE.getUnchecked(this.launch)).getChildren());
        if (StringUtils.isBlank((CharSequence)this.getParameters().getLaunchUuid())) {
            FinishExecutionRQ rq = ObjectUtils.clonePojo(request, FinishExecutionRQ.class);
            this.truncateAttributes(rq);
            finish = finish.andThen((MaybeSource)this.launch.map(id -> (OperationCompletionRS)this.getClient().finishLaunch((String)id, rq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LaunchLoggingCallback.LOG_SUCCESS).doOnError(LaunchLoggingCallback.LOG_ERROR).blockingGet())).ignoreElement();
        }
        if ((error = (finish = finish.cache()).timeout((long)this.getParameters().getReportingTimeout().intValue(), TimeUnit.SECONDS).blockingGet()) != null) {
            LOGGER.error("Unable to finish launch in ReportPortal", error);
        }
        this.getStatisticsService().close();
        this.statisticsService = new StatisticsService(this.getParameters());
    }

    private static <T> Maybe<T> createErrorResponse(Throwable cause) {
        LOGGER.error(cause.getMessage(), cause);
        return Maybe.error((Throwable)cause);
    }

    @Override
    @Nonnull
    public Maybe<String> startTestItem(StartTestItemRQ request) {
        if (request == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("StartTestItemRQ should not be null"));
        }
        StartTestItemRQ rq = ObjectUtils.clonePojo(request, StartTestItemRQ.class);
        this.truncateName(rq);
        this.truncateAttributes((StartRQ)rq);
        Maybe item = this.launch.flatMap(launchId -> {
            rq.setLaunchUuid(launchId);
            return this.getClient().startTestItem(rq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LaunchLoggingCallback.logCreated("item")).map(TO_ID);
        }).cache();
        item.subscribeOn(this.getScheduler()).subscribe(SubscriptionUtils.logMaybeResults("Start test item"));
        ((TreeItem)this.QUEUE.getUnchecked((Object)item)).addToQueue(item.ignoreElement().onErrorComplete());
        LoggingContext.init(this.launch, (Maybe<String>)item, this.getClient(), this.getScheduler(), this.getParameters());
        this.getStepReporter().setParent((Maybe<String>)item);
        return item;
    }

    @Override
    @Nonnull
    public Maybe<String> startTestItem(Maybe<String> parentId, Maybe<String> retryOf, StartTestItemRQ rq) {
        return retryOf.flatMap(s -> this.startTestItem(parentId, rq)).cache();
    }

    @Override
    @Nonnull
    public Maybe<String> startTestItem(Maybe<String> parentId, StartTestItemRQ request) {
        if (parentId == null) {
            return this.startTestItem(request);
        }
        if (request == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("StartTestItemRQ should not be null"));
        }
        StartTestItemRQ rq = ObjectUtils.clonePojo(request, StartTestItemRQ.class);
        this.truncateName(rq);
        this.truncateAttributes((StartRQ)rq);
        Maybe item = this.launch.flatMap(lId -> parentId.flatMap(pId -> {
            rq.setLaunchUuid(lId);
            LOGGER.debug("Starting test item..." + Thread.currentThread().getName());
            Maybe result = this.getClient().startTestItem((String)pId, rq);
            result = result.retry((Predicate)DEFAULT_REQUEST_RETRY);
            result = result.doOnSuccess(LaunchLoggingCallback.logCreated("item"));
            return result.map(TO_ID);
        })).cache();
        item.subscribeOn(this.getScheduler()).subscribe(SubscriptionUtils.logMaybeResults("Start test item"));
        ((TreeItem)this.QUEUE.getUnchecked((Object)item)).withParent(parentId).addToQueue(item.ignoreElement().onErrorComplete());
        LoggingContext.init(this.launch, (Maybe<String>)item, this.getClient(), this.getScheduler(), this.getParameters());
        this.getStepReporter().setParent((Maybe<String>)item);
        return item;
    }

    @Override
    @Nonnull
    public Maybe<OperationCompletionRS> finishTestItem(Maybe<String> item, FinishTestItemRQ request) {
        if (item == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("ItemID should not be null"));
        }
        if (request == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("FinishTestItemRQ should not be null"));
        }
        FinishTestItemRQ rq = ObjectUtils.clonePojo(request, FinishTestItemRQ.class);
        this.truncateAttributes((FinishExecutionRQ)rq);
        this.getStepReporter().finishPreviousStep(Optional.ofNullable(rq.getStatus()).map(ItemStatus::valueOf).orElse(null));
        if (ItemStatus.SKIPPED.name().equals(rq.getStatus()) && !this.getParameters().getSkippedAnIssue().booleanValue()) {
            rq.setIssue(Launch.NOT_ISSUE);
        }
        ((TreeItem)this.QUEUE.getUnchecked(this.launch)).addToQueue(LoggingContext.complete());
        TreeItem treeItem = (TreeItem)this.QUEUE.getIfPresent(item);
        if (null == treeItem) {
            treeItem = new TreeItem();
            LOGGER.error("Item {} not found in the cache", item);
        }
        if (this.getStepReporter().isFailed(item)) {
            rq.setStatus(ItemStatus.FAILED.name());
        }
        Maybe finishResponse = this.launch.flatMap(launchId -> item.flatMap(itemId -> {
            rq.setLaunchUuid(launchId);
            return this.getClient().finishTestItem((String)itemId, rq).retry((Predicate)TEST_ITEM_FINISH_REQUEST_RETRY).doOnSuccess(LaunchLoggingCallback.LOG_SUCCESS).doOnError(LaunchLoggingCallback.LOG_ERROR);
        })).cache();
        Completable finishCompletion = Completable.concat(treeItem.getChildren()).andThen((MaybeSource)finishResponse).doAfterTerminate(() -> this.QUEUE.invalidate((Object)item)).ignoreElement().cache();
        finishCompletion.subscribeOn(this.getScheduler()).subscribe(SubscriptionUtils.logCompletableResults("Finish test item"));
        Maybe<String> parent = treeItem.getParent();
        if (null != parent) {
            ((TreeItem)this.QUEUE.getUnchecked(parent)).addToQueue(finishCompletion.onErrorComplete());
        } else {
            ((TreeItem)this.QUEUE.getUnchecked(this.launch)).addToQueue(finishCompletion.onErrorComplete());
        }
        this.getStepReporter().removeParent(item);
        return finishResponse;
    }

    protected static class TreeItem {
        private volatile Maybe<String> parent;
        private final List<Completable> children = new CopyOnWriteArrayList<Completable>();

        protected TreeItem() {
        }

        public TreeItem withParent(Maybe<String> parent) {
            this.parent = parent;
            return this;
        }

        public void addToQueue(Completable completable) {
            this.children.add(completable);
        }

        public List<Completable> getChildren() {
            return Lists.newArrayList(this.children);
        }

        public Maybe<String> getParent() {
            return this.parent;
        }
    }
}

