/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.templating;

import com.epam.reportportal.utils.reflect.Accessible;
import com.epam.reportportal.utils.templating.TemplateConfiguration;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateProcessing {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateProcessing.class);
    private static final String NULL_VALUE = "NULL";
    private static final Pattern TEMPLATE_GROUP = Pattern.compile("\\{([\\w$]+(\\.[\\w$]+)*)}");

    private TemplateProcessing() {
        throw new IllegalStateException("Static only class");
    }

    public static String processTemplate(@Nonnull String pattern, @Nullable Object object, @Nullable Executable executable, @Nullable Map<String, Object> parameters, @Nonnull TemplateConfiguration config) {
        HashMap<String, Object> myParams = Optional.ofNullable(parameters).map(HashMap::new).orElse(new HashMap());
        Optional.ofNullable(executable).ifPresent(e -> {
            myParams.put(config.getMethodName(), e.getName());
            Class<?> clazz = e.getDeclaringClass();
            myParams.put(config.getClassName(), clazz.getSimpleName());
            myParams.put(config.getClassRef(), clazz.getName());
        });
        Optional.ofNullable(object).ifPresent(o -> myParams.put(config.getSelfName(), object));
        Matcher matcher = TEMPLATE_GROUP.matcher(pattern);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String templatePart = matcher.group(1);
            String replacement = TemplateProcessing.getReplacement(templatePart, myParams, config);
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(replacement != null ? replacement : matcher.group(0)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String processTemplate(@Nonnull String pattern, @Nullable Map<String, Object> parameters, @Nonnull TemplateConfiguration config) {
        return TemplateProcessing.processTemplate(pattern, null, null, parameters, config);
    }

    @Nullable
    private static String getReplacement(@Nonnull String templatePart, @Nonnull Map<String, Object> parametersMap, @Nonnull TemplateConfiguration templateConfig) {
        String[] fields = templatePart.split(Pattern.quote(templateConfig.getFieldDelimiter()));
        String variableName = fields[0];
        if (!parametersMap.containsKey(variableName)) {
            LOGGER.error("Param - " + variableName + " was not found");
            return null;
        }
        Object param = parametersMap.get(variableName);
        try {
            return TemplateProcessing.retrieveValue(templateConfig, 1, fields, param);
        }
        catch (NoSuchFieldException e) {
            LOGGER.error("Unable to parse: " + templatePart);
            return null;
        }
    }

    public static String retrieveValue(TemplateConfiguration templateConfig, int index, String[] fields, Object object) throws NoSuchFieldException {
        if (object == null) {
            return NULL_VALUE;
        }
        for (int i = index; i < fields.length; ++i) {
            if (object.getClass().isArray()) {
                return TemplateProcessing.parseArray(templateConfig, (Object[])object, i, fields);
            }
            if (object instanceof Iterable) {
                return TemplateProcessing.parseCollection(templateConfig, (Iterable)object, i, fields);
            }
            object = Accessible.on(object).field(fields[i]).getValue();
        }
        return TemplateProcessing.parseDescendant(templateConfig, object);
    }

    private static String parseArray(TemplateConfiguration templateConfig, Object[] array, int index, String[] fields) throws NoSuchFieldException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(templateConfig.getArrayStart());
        for (int i = 0; i < array.length; ++i) {
            stringBuilder.append(TemplateProcessing.retrieveValue(templateConfig, index, fields, array[i]));
            if (i >= array.length - 1) continue;
            stringBuilder.append(templateConfig.getArrayDelimiter());
        }
        stringBuilder.append(templateConfig.getArrayEnd());
        return stringBuilder.toString();
    }

    private static String parseCollection(TemplateConfiguration templateConfig, Iterable<?> iterable, int index, String[] fields) throws NoSuchFieldException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(templateConfig.getIterableStart());
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(TemplateProcessing.retrieveValue(templateConfig, index, fields, iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(templateConfig.getIterableDelimiter());
        }
        stringBuilder.append(templateConfig.getIterableEnd());
        return stringBuilder.toString();
    }

    private static String parseDescendant(TemplateConfiguration templateConfig, Object descendant) {
        if (descendant == null) {
            return NULL_VALUE;
        }
        if (descendant.getClass().isArray()) {
            return TemplateProcessing.parseDescendantArray(templateConfig, descendant);
        }
        if (descendant instanceof Iterable) {
            return TemplateProcessing.parseDescendantCollection(templateConfig, (Iterable)descendant);
        }
        return String.valueOf(descendant);
    }

    private static String parseDescendantArray(TemplateConfiguration templateConfig, Object array) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(templateConfig.getArrayStart());
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(TemplateProcessing.parseDescendant(templateConfig, Array.get(array, i)));
            if (i >= length - 1) continue;
            stringBuilder.append(templateConfig.getArrayDelimiter());
        }
        stringBuilder.append(templateConfig.getArrayEnd());
        return stringBuilder.toString();
    }

    private static String parseDescendantCollection(TemplateConfiguration templateConfig, Iterable<?> iterable) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(templateConfig.getIterableStart());
        Iterator<?> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(TemplateProcessing.parseDescendant(templateConfig, iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(templateConfig.getIterableDelimiter());
        }
        stringBuilder.append(templateConfig.getIterableEnd());
        return stringBuilder.toString();
    }
}

