/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.reportportal.utils.files.ImageConverter;
import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.google.common.io.ByteSource;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.Scheduler;
import io.reactivex.internal.operators.flowable.FlowableFromObservable;
import io.reactivex.subjects.PublishSubject;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class LaunchLoggingContext {
    static final String DEFAULT_LAUNCH_KEY = "default";
    private static final ConcurrentHashMap<String, LaunchLoggingContext> loggingContextMap = new ConcurrentHashMap();
    private final PublishSubject<Maybe<SaveLogRQ>> emitter;
    private final Maybe<String> launchUuid;
    private final boolean convertImages;

    private LaunchLoggingContext(Maybe<String> launchUuid, ReportPortalClient client, Scheduler scheduler, ListenerParameters parameters) {
        this.launchUuid = launchUuid;
        this.emitter = PublishSubject.create();
        this.convertImages = parameters.isConvertImage();
        new FlowableFromObservable(this.emitter).flatMap(Maybe::toFlowable).buffer(parameters.getBatchLogsSize().intValue()).flatMap(rqs -> client.log(HttpRequestUtils.buildLogMultiPartRequest(rqs)).toFlowable()).doOnError(Throwable::printStackTrace).observeOn(scheduler).onBackpressureBuffer(parameters.getRxBufferSize(), false, true).subscribe(SubscriptionUtils.logFlowableResults("Launch logging context"));
    }

    @Nullable
    public static LaunchLoggingContext context(String key) {
        return loggingContextMap.get(key);
    }

    public static LaunchLoggingContext init(Maybe<String> launchUuid, ReportPortalClient client, Scheduler scheduler, ListenerParameters parameters) {
        LaunchLoggingContext context = new LaunchLoggingContext(launchUuid, client, scheduler, parameters);
        loggingContextMap.put(DEFAULT_LAUNCH_KEY, context);
        return context;
    }

    static LaunchLoggingContext init(Maybe<String> launchUuid, ReportPortalClient client, Scheduler scheduler) {
        return LaunchLoggingContext.init(launchUuid, client, scheduler, 10, false);
    }

    static LaunchLoggingContext init(Maybe<String> launchUuid, ReportPortalClient client, Scheduler scheduler, int batchLogsSize, boolean convertImages) {
        ListenerParameters params = new ListenerParameters();
        params.setBatchLogsSize(batchLogsSize);
        params.setConvertImage(convertImages);
        LaunchLoggingContext context = new LaunchLoggingContext(launchUuid, client, scheduler, params);
        loggingContextMap.put(DEFAULT_LAUNCH_KEY, context);
        return context;
    }

    public static Completable complete() {
        LaunchLoggingContext loggingContext = loggingContextMap.get(DEFAULT_LAUNCH_KEY);
        if (null != loggingContext) {
            return loggingContext.completed();
        }
        return Maybe.empty().ignoreElement();
    }

    void emit(Function<String, SaveLogRQ> logSupplier) {
        this.emitter.onNext((Object)this.launchUuid.map(input -> {
            SaveLogRQ rq = (SaveLogRQ)logSupplier.apply((String)input);
            SaveLogRQ.File file = rq.getFile();
            if (this.convertImages && null != file && ImageConverter.isImage(file.getContentType())) {
                TypeAwareByteSource source = ImageConverter.convert(ByteSource.wrap((byte[])file.getContent()));
                file.setContent(source.read());
                file.setContentType(source.getMediaType());
            }
            return rq;
        }));
    }

    private Completable completed() {
        this.emitter.onComplete();
        return this.emitter.ignoreElements();
    }
}

