/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.exception.ReportPortalException;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.LaunchLoggingContext;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.logs.LaunchLoggingCallback;
import com.epam.reportportal.service.statistics.StatisticsService;
import com.epam.reportportal.utils.ObjectUtils;
import com.epam.reportportal.utils.RetryWithDelay;
import com.epam.reportportal.utils.StaticStructuresUtils;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.reportportal.utils.properties.DefaultProperties;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.item.ItemCreatedRS;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRS;
import com.epam.ta.reportportal.ws.model.project.config.ProjectSettingsResource;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Scheduler;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class LaunchImpl
extends Launch {
    public static final String DISABLE_PROPERTY = "AGENT_NO_ANALYTICS";
    private static final Map<ExecutorService, Scheduler> SCHEDULERS = new ConcurrentHashMap<ExecutorService, Scheduler>();
    private static final Function<ItemCreatedRS, String> TO_ID = EntryCreatedAsyncRS::getId;
    private static final Consumer<StartLaunchRS> LAUNCH_SUCCESS_CONSUMER = rs -> {
        LaunchLoggingCallback.logCreated("launch").accept(rs);
        System.setProperty("rp.launch.id", String.valueOf(rs.getId()));
    };
    private static final int DEFAULT_RETRY_COUNT = 5;
    private static final int DEFAULT_RETRY_TIMEOUT = 2;
    private static final int ITEM_FINISH_MAX_RETRIES = 10;
    private static final int ITEM_FINISH_RETRY_TIMEOUT = 10;
    private static final Predicate<Throwable> INTERNAL_CLIENT_EXCEPTION_PREDICATE = throwable -> throwable instanceof InternalReportPortalClientException;
    private static final Predicate<Throwable> TEST_ITEM_FINISH_RETRY_PREDICATE = throwable -> throwable instanceof ReportPortalException && ErrorType.FINISH_ITEM_NOT_ALLOWED.equals((Object)((ReportPortalException)throwable).getError().getErrorType()) || INTERNAL_CLIENT_EXCEPTION_PREDICATE.test(throwable);
    private static final RetryWithDelay DEFAULT_REQUEST_RETRY = new RetryWithDelay(INTERNAL_CLIENT_EXCEPTION_PREDICATE, 5L, TimeUnit.SECONDS.toMillis(2L));
    private static final RetryWithDelay TEST_ITEM_FINISH_REQUEST_RETRY = new RetryWithDelay(TEST_ITEM_FINISH_RETRY_PREDICATE, 10L, TimeUnit.SECONDS.toMillis(10L));
    @Deprecated
    public static final String NOT_ISSUE = "NOT_ISSUE";
    public static final String CUSTOM_AGENT = "CUSTOM";
    protected final ComputationConcurrentHashMap QUEUE = new ComputationConcurrentHashMap();
    protected final Maybe<String> launch;
    protected final StartLaunchRQ startRq;
    protected final Maybe<ProjectSettingsResource> projectSettings;
    private final ExecutorService executor;
    private final Scheduler scheduler;
    private StatisticsService statisticsService;

    protected LaunchImpl(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters parameters, @Nonnull StartLaunchRQ rq, @Nonnull ExecutorService executorService) {
        super(reportPortalClient, parameters);
        Objects.requireNonNull(parameters, "Parameters shouldn't be NULL");
        this.executor = Objects.requireNonNull(executorService);
        this.scheduler = this.createScheduler(this.executor);
        this.statisticsService = new StatisticsService(parameters);
        this.startRq = ObjectUtils.clonePojo(rq, StartLaunchRQ.class);
        LOGGER.info("Rerun: {}", (Object)parameters.isRerun());
        this.launch = Maybe.create(emitter -> {
            Maybe launchPromise = Maybe.defer(() -> {
                this.truncateAttributes((StartRQ)this.startRq);
                return this.getClient().startLaunch(this.startRq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LAUNCH_SUCCESS_CONSUMER).doOnError(LaunchLoggingCallback.LOG_ERROR);
            }).subscribeOn(this.getScheduler()).cache();
            launchPromise.subscribe(rs -> emitter.onSuccess((Object)rs.getId()), t -> {
                LaunchLoggingCallback.LOG_ERROR.accept(t);
                emitter.onComplete();
            });
        }).cache();
        this.projectSettings = Optional.ofNullable(this.getClient().getProjectSettings()).map(settings -> settings.subscribeOn(this.getScheduler()).cache()).orElse(Maybe.empty());
    }

    protected LaunchImpl(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters parameters, @Nonnull Maybe<String> launchMaybe, @Nonnull ExecutorService executorService) {
        super(reportPortalClient, parameters);
        Objects.requireNonNull(parameters, "Parameters shouldn't be NULL");
        this.executor = Objects.requireNonNull(executorService);
        this.scheduler = this.createScheduler(this.executor);
        this.statisticsService = new StatisticsService(parameters);
        this.startRq = LaunchImpl.emptyStartLaunchForStatistics();
        LOGGER.info("Rerun: {}", (Object)parameters.isRerun());
        this.launch = launchMaybe.cache();
        this.projectSettings = Optional.ofNullable(this.getClient().getProjectSettings()).map(settings -> settings.subscribeOn(this.getScheduler()).cache()).orElse(Maybe.empty());
    }

    private static StartLaunchRQ emptyStartLaunchForStatistics() {
        StartLaunchRQ result = new StartLaunchRQ();
        result.setAttributes(Collections.singleton(new ItemAttributesRQ(DefaultProperties.AGENT.getName(), CUSTOM_AGENT, true)));
        return result;
    }

    protected Scheduler createScheduler(ExecutorService executorService) {
        return SCHEDULERS.computeIfAbsent(executorService, Schedulers::from);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    @Nonnull
    public Maybe<String> getLaunch() {
        return this.launch;
    }

    StatisticsService getStatisticsService() {
        return this.statisticsService;
    }

    private void truncateName(@Nonnull StartTestItemRQ rq) {
        if (!this.getParameters().isTruncateFields() || rq.getName() == null || rq.getName().isEmpty()) {
            return;
        }
        String name = rq.getName();
        int limit = this.getParameters().getTruncateItemNamesLimit();
        String replacement = this.getParameters().getTruncateReplacement();
        if (name.length() > limit && name.length() > replacement.length()) {
            rq.setName(name.substring(0, limit - replacement.length()) + replacement);
        }
    }

    @Nullable
    private Set<ItemAttributesRQ> truncateAttributes(@Nullable Set<ItemAttributesRQ> attributes) {
        if (!this.getParameters().isTruncateFields() || attributes == null || attributes.isEmpty()) {
            return attributes;
        }
        int limit = this.getParameters().getAttributeLengthLimit();
        String replacement = this.getParameters().getTruncateReplacement();
        return attributes.stream().map(attribute -> {
            int valueLength;
            ItemAttributesRQ updated = attribute;
            int keyLength = Optional.ofNullable(updated.getKey()).map(String::length).orElse(0);
            if (keyLength > limit && keyLength > replacement.length()) {
                updated = new ItemAttributesRQ(updated.getKey().substring(0, limit - replacement.length()) + replacement, updated.getValue(), updated.isSystem());
            }
            if ((valueLength = Optional.ofNullable(updated.getValue()).map(String::length).orElse(0).intValue()) > limit && valueLength > replacement.length()) {
                updated = new ItemAttributesRQ(updated.getKey(), updated.getValue().substring(0, limit - replacement.length()) + replacement, updated.isSystem());
            }
            return updated;
        }).collect(Collectors.toSet());
    }

    private void truncateAttributes(@Nonnull StartRQ rq) {
        rq.setAttributes(this.truncateAttributes(rq.getAttributes()));
    }

    private void truncateAttributes(@Nonnull FinishExecutionRQ rq) {
        rq.setAttributes(this.truncateAttributes(rq.getAttributes()));
    }

    @Nonnull
    protected Maybe<String> start(boolean statistics) {
        this.launch.subscribe(SubscriptionUtils.logMaybeResults("Launch start"));
        ListenerParameters params = this.getParameters();
        if (params.isPrintLaunchUuid()) {
            this.launch.subscribe(SubscriptionUtils.printLaunch(params));
        }
        LaunchLoggingContext.init(this.launch, this.getClient(), this.getScheduler(), this.getParameters());
        if (statistics) {
            this.getStatisticsService().sendEvent(this.launch, this.startRq);
        }
        return this.launch;
    }

    @Override
    @Nonnull
    public Maybe<String> start() {
        return this.start(System.getenv(DISABLE_PROPERTY) == null);
    }

    @Override
    public void finish(FinishExecutionRQ request) {
        Throwable error;
        this.QUEUE.getOrCompute(this.launch).addToQueue(LaunchLoggingContext.complete());
        Completable finish = Completable.concat(this.QUEUE.getOrCompute(this.launch).getChildren());
        if (StringUtils.isBlank((CharSequence)this.getParameters().getLaunchUuid())) {
            FinishExecutionRQ rq = ObjectUtils.clonePojo(request, FinishExecutionRQ.class);
            this.truncateAttributes(rq);
            finish = finish.andThen((MaybeSource)this.launch.map(id -> (OperationCompletionRS)this.getClient().finishLaunch((String)id, rq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LaunchLoggingCallback.LOG_SUCCESS).doOnError(LaunchLoggingCallback.LOG_ERROR).blockingGet())).ignoreElement();
        }
        if ((error = (finish = finish.cache()).timeout((long)this.getParameters().getReportingTimeout().intValue(), TimeUnit.SECONDS).blockingGet()) != null) {
            LOGGER.error("Unable to finish launch in ReportPortal", error);
        }
        this.getStatisticsService().close();
        this.statisticsService = new StatisticsService(this.getParameters());
    }

    private static <T> Maybe<T> createErrorResponse(Throwable cause) {
        LOGGER.error(cause.getMessage(), cause);
        return Maybe.error((Throwable)cause);
    }

    @Override
    @Nonnull
    public Maybe<String> startTestItem(StartTestItemRQ request) {
        if (request == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("StartTestItemRQ should not be null"));
        }
        StartTestItemRQ rq = ObjectUtils.clonePojo(request, StartTestItemRQ.class);
        this.truncateName(rq);
        this.truncateAttributes((StartRQ)rq);
        Maybe item = this.launch.flatMap(launchId -> {
            rq.setLaunchUuid(launchId);
            return this.getClient().startTestItem(rq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LaunchLoggingCallback.logCreated("item")).map(TO_ID);
        }).cache();
        item.subscribeOn(this.getScheduler()).subscribe(SubscriptionUtils.logMaybeResults("Start test item"));
        this.QUEUE.getOrCompute((Maybe<String>)item).addToQueue(item.ignoreElement().onErrorComplete());
        LoggingContext.init(this.launch, (Maybe<String>)item, this.getClient(), this.getScheduler(), this.getParameters());
        this.getStepReporter().setParent((Maybe<String>)item);
        return item;
    }

    @Override
    @Nonnull
    public Maybe<String> startTestItem(Maybe<String> parentId, Maybe<String> retryOf, StartTestItemRQ rq) {
        return retryOf.flatMap(s -> this.startTestItem(parentId, rq)).cache();
    }

    @Override
    @Nonnull
    public Maybe<String> startTestItem(Maybe<String> parentId, StartTestItemRQ request) {
        if (parentId == null) {
            return this.startTestItem(request);
        }
        if (request == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("StartTestItemRQ should not be null"));
        }
        StartTestItemRQ rq = ObjectUtils.clonePojo(request, StartTestItemRQ.class);
        this.truncateName(rq);
        this.truncateAttributes((StartRQ)rq);
        Maybe item = this.launch.flatMap(lId -> parentId.flatMap(pId -> {
            rq.setLaunchUuid(lId);
            LOGGER.debug("Starting test item..." + Thread.currentThread().getName());
            Maybe result = this.getClient().startTestItem((String)pId, rq);
            result = result.retry((Predicate)DEFAULT_REQUEST_RETRY);
            result = result.doOnSuccess(LaunchLoggingCallback.logCreated("item"));
            return result.map(TO_ID);
        })).cache();
        item.subscribeOn(this.getScheduler()).subscribe(SubscriptionUtils.logMaybeResults("Start test item"));
        this.QUEUE.getOrCompute((Maybe<String>)item).withParent(parentId).addToQueue(item.ignoreElement().onErrorComplete());
        LoggingContext.init(this.launch, (Maybe<String>)item, this.getClient(), this.getScheduler(), this.getParameters());
        this.getStepReporter().setParent((Maybe<String>)item);
        return item;
    }

    protected void completeIssues(@Nonnull Issue issue) {
        String issueType = issue.getIssueType();
        if (StringUtils.isBlank((CharSequence)issueType)) {
            return;
        }
        Optional.ofNullable(this.projectSettings.blockingGet()).map(ProjectSettingsResource::getSubTypes).ifPresent(subTypes -> subTypes.values().stream().flatMap(Collection::stream).forEach(value -> {
            if (issueType.equals(value.getLocator())) {
                return;
            }
            if (issueType.equalsIgnoreCase(value.getShortName())) {
                issue.setIssueType(value.getLocator());
                return;
            }
            if (issueType.equalsIgnoreCase(value.getLongName())) {
                issue.setIssueType(value.getLocator());
                return;
            }
            if (issueType.equals(value.getTypeRef())) {
                issue.setIssueType(value.getLocator());
            }
        }));
        if (!Optional.ofNullable(issue.getExternalSystemIssues()).filter(issues -> !issues.isEmpty()).isPresent()) {
            return;
        }
        ListenerParameters params = this.getParameters();
        Optional<String> btsUrl = Optional.ofNullable(params.getBtsUrl()).filter(StringUtils::isNotBlank);
        Optional<String> btsProjectId = Optional.ofNullable(params.getBtsProjectId()).filter(StringUtils::isNotBlank);
        Optional<String> btsIssueUrl = Optional.ofNullable(params.getBtsIssueUrl()).filter(StringUtils::isNotBlank);
        issue.getExternalSystemIssues().stream().filter(Objects::nonNull).forEach(externalIssue -> {
            if (StringUtils.isBlank((CharSequence)externalIssue.getTicketId())) {
                return;
            }
            if (btsUrl.isPresent() && StringUtils.isBlank((CharSequence)externalIssue.getBtsUrl())) {
                externalIssue.setBtsUrl((String)btsUrl.get());
            }
            if (btsProjectId.isPresent() && StringUtils.isBlank((CharSequence)externalIssue.getBtsProject())) {
                externalIssue.setBtsProject((String)btsProjectId.get());
            }
            if (btsIssueUrl.isPresent() && StringUtils.isBlank((CharSequence)externalIssue.getUrl())) {
                externalIssue.setUrl((String)btsIssueUrl.get());
            }
            if (StringUtils.isNotBlank((CharSequence)externalIssue.getUrl())) {
                if (StringUtils.isNotBlank((CharSequence)externalIssue.getTicketId())) {
                    externalIssue.setUrl(externalIssue.getUrl().replace("{issue_id}", externalIssue.getTicketId()));
                }
                if (StringUtils.isNotBlank((CharSequence)externalIssue.getBtsProject())) {
                    externalIssue.setUrl(externalIssue.getUrl().replace("{bts_project}", externalIssue.getBtsProject()));
                }
            }
        });
    }

    @Override
    @Nonnull
    public Maybe<OperationCompletionRS> finishTestItem(Maybe<String> item, FinishTestItemRQ request) {
        if (item == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("ItemID should not be null"));
        }
        if (request == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("FinishTestItemRQ should not be null"));
        }
        FinishTestItemRQ rq = ObjectUtils.clonePojo(request, FinishTestItemRQ.class);
        this.truncateAttributes((FinishExecutionRQ)rq);
        this.getStepReporter().finishPreviousStep(Optional.ofNullable(rq.getStatus()).map(ItemStatus::valueOf).orElse(null));
        ItemStatus status = Optional.ofNullable(rq.getStatus()).map(ItemStatus::valueOf).orElse(null);
        if (rq.getIssue() == null) {
            if (status == ItemStatus.SKIPPED && !this.getParameters().getSkippedAnIssue().booleanValue()) {
                rq.setIssue(Launch.NOT_ISSUE);
            }
        } else if (status == ItemStatus.FAILED || status == ItemStatus.SKIPPED && this.getParameters().getSkippedAnIssue().booleanValue()) {
            this.completeIssues(rq.getIssue());
        } else if (status == ItemStatus.PASSED) {
            if (this.getParameters().isBtsIssueFail()) {
                rq.setStatus(ItemStatus.FAILED.name());
                rq.setIssue(StaticStructuresUtils.REDUNDANT_ISSUE);
            } else {
                rq.setIssue(null);
            }
        }
        this.QUEUE.getOrCompute(this.launch).addToQueue(LoggingContext.complete());
        TreeItem treeItem = (TreeItem)this.QUEUE.get(item);
        if (null == treeItem) {
            treeItem = new TreeItem();
            LOGGER.error("Item {} not found in the cache", item);
        }
        if (this.getStepReporter().isFailed(item)) {
            rq.setStatus(ItemStatus.FAILED.name());
        }
        Maybe finishResponse = this.launch.flatMap(launchId -> item.flatMap(itemId -> {
            rq.setLaunchUuid(launchId);
            return this.getClient().finishTestItem((String)itemId, rq).retry((Predicate)TEST_ITEM_FINISH_REQUEST_RETRY).doOnSuccess(LaunchLoggingCallback.LOG_SUCCESS).doOnError(LaunchLoggingCallback.LOG_ERROR);
        })).cache();
        Completable finishCompletion = Completable.concat(treeItem.getChildren()).andThen((MaybeSource)finishResponse).doAfterTerminate(() -> {
            TreeItem cfr_ignored_0 = (TreeItem)this.QUEUE.remove(item);
        }).ignoreElement().cache();
        finishCompletion.subscribeOn(this.getScheduler()).subscribe(SubscriptionUtils.logCompletableResults("Finish test item"));
        Maybe<String> parent = treeItem.getParent();
        if (null != parent) {
            this.QUEUE.getOrCompute(parent).addToQueue(finishCompletion.onErrorComplete());
        } else {
            this.QUEUE.getOrCompute(this.launch).addToQueue(finishCompletion.onErrorComplete());
        }
        this.getStepReporter().removeParent(item);
        return finishResponse;
    }

    protected static class ComputationConcurrentHashMap
    extends ConcurrentHashMap<Maybe<String>, TreeItem> {
        protected ComputationConcurrentHashMap() {
        }

        public TreeItem getOrCompute(Maybe<String> key) {
            return this.computeIfAbsent(key, k -> new TreeItem());
        }
    }

    protected static class TreeItem {
        private volatile Maybe<String> parent;
        private final List<Completable> children = new CopyOnWriteArrayList<Completable>();

        protected TreeItem() {
        }

        public TreeItem withParent(@Nullable Maybe<String> parent) {
            this.parent = parent;
            return this;
        }

        public void addToQueue(@Nonnull Completable completable) {
            this.children.add(completable);
        }

        @Nonnull
        public List<Completable> getChildren() {
            return new ArrayList<Completable>(this.children);
        }

        @Nullable
        public Maybe<String> getParent() {
            return this.parent;
        }
    }
}

