/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.exception.ReportPortalException;
import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.LoggingContext;
import com.epam.reportportal.service.ReportPortalClient;
import com.epam.reportportal.service.logs.LaunchLoggingCallback;
import com.epam.reportportal.service.logs.LogBatchingFlowable;
import com.epam.reportportal.service.logs.LoggingSubscriber;
import com.epam.reportportal.service.statistics.StatisticsService;
import com.epam.reportportal.utils.MemoizingSupplier;
import com.epam.reportportal.utils.MultithreadingUtils;
import com.epam.reportportal.utils.ObjectUtils;
import com.epam.reportportal.utils.RetryWithDelay;
import com.epam.reportportal.utils.StaticStructuresUtils;
import com.epam.reportportal.utils.SubscriptionUtils;
import com.epam.reportportal.utils.files.ByteSource;
import com.epam.reportportal.utils.files.ImageConverter;
import com.epam.reportportal.utils.http.HttpRequestUtils;
import com.epam.reportportal.utils.properties.DefaultProperties;
import com.epam.ta.reportportal.ws.model.BatchSaveOperatingRS;
import com.epam.ta.reportportal.ws.model.EntryCreatedAsyncRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartRQ;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.attribute.ItemAttributesRQ;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.item.ItemCreatedRS;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.epam.ta.reportportal.ws.model.project.config.ProjectSettingsResource;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.FlowableSubscriber;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.functions.Predicate;
import io.reactivex.internal.operators.flowable.FlowableFromObservable;
import io.reactivex.plugins.RxJavaPlugins;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class LaunchImpl
extends Launch {
    public static final String DISABLE_PROPERTY = "AGENT_NO_ANALYTICS";
    private static final Map<ExecutorService, Scheduler> SCHEDULERS = new ConcurrentHashMap<ExecutorService, Scheduler>();
    private static final Function<ItemCreatedRS, String> TO_ID = EntryCreatedAsyncRS::getId;
    private static final int DEFAULT_RETRY_COUNT = 5;
    private static final int DEFAULT_RETRY_TIMEOUT = 2;
    private static final int ITEM_FINISH_MAX_RETRIES = 10;
    private static final int ITEM_FINISH_RETRY_TIMEOUT = 10;
    private static final Predicate<Throwable> INTERNAL_CLIENT_EXCEPTION_PREDICATE = throwable -> throwable instanceof InternalReportPortalClientException;
    private static final Predicate<Throwable> TEST_ITEM_FINISH_RETRY_PREDICATE = throwable -> throwable instanceof ReportPortalException && ErrorType.FINISH_ITEM_NOT_ALLOWED.equals((Object)((ReportPortalException)throwable).getError().getErrorType()) || INTERNAL_CLIENT_EXCEPTION_PREDICATE.test(throwable);
    private static final RetryWithDelay DEFAULT_REQUEST_RETRY = new RetryWithDelay(INTERNAL_CLIENT_EXCEPTION_PREDICATE, 5L, TimeUnit.SECONDS.toMillis(2L));
    private static final RetryWithDelay TEST_ITEM_FINISH_REQUEST_RETRY = new RetryWithDelay(TEST_ITEM_FINISH_RETRY_PREDICATE, 10L, TimeUnit.SECONDS.toMillis(10L));
    public static final String CUSTOM_AGENT = "CUSTOM";
    protected final ComputationConcurrentHashMap queue = new ComputationConcurrentHashMap();
    protected final Map<Maybe<String>, PublishSubject<String>> virtualItems = new ConcurrentHashMap<Maybe<String>, PublishSubject<String>>();
    protected final Queue<Disposable> virtualItemDisposables = new ConcurrentLinkedQueue<Disposable>();
    protected final Queue<Completable> logCompletables = new ConcurrentLinkedQueue<Completable>();
    protected final StartLaunchRQ startRq;
    protected final Maybe<ProjectSettingsResource> projectSettings;
    private final Supplier<Maybe<String>> launch;
    private final AtomicBoolean isShutDownHook = new AtomicBoolean(false);
    private final PublishSubject<SaveLogRQ> logEmitter;
    private final ExecutorService executor;
    private final Scheduler scheduler;
    private StatisticsService statisticsService;

    private static Supplier<Maybe<String>> getLaunchSupplier(@Nonnull ReportPortalClient client, @Nonnull Scheduler scheduler, @Nonnull StartLaunchRQ startRq) {
        return new MemoizingSupplier<Maybe<String>>(() -> client.startLaunch(startRq).retry((Predicate)DEFAULT_REQUEST_RETRY).map(EntryCreatedAsyncRS::getId).cache().subscribeOn(scheduler));
    }

    private static PublishSubject<SaveLogRQ> getLogEmitter(@Nonnull ReportPortalClient client, @Nonnull ListenerParameters parameters, @Nonnull Scheduler scheduler, @Nonnull FlowableSubscriber<BatchSaveOperatingRS> loggingSubscriber) {
        PublishSubject emitter = PublishSubject.create();
        RxJavaPlugins.onAssembly((Flowable)new LogBatchingFlowable((Flowable<SaveLogRQ>)new FlowableFromObservable((Observable)emitter), parameters)).flatMap(rqs -> client.log(HttpRequestUtils.buildLogMultiPartRequest(rqs)).retry((Predicate)DEFAULT_REQUEST_RETRY).toFlowable()).onBackpressureBuffer(parameters.getRxBufferSize(), false, true).cache().subscribeOn(scheduler).subscribe(loggingSubscriber);
        return emitter;
    }

    private static Maybe<ProjectSettingsResource> getProjectSettings(@Nonnull ReportPortalClient client, @Nonnull Scheduler scheduler) {
        return Optional.ofNullable(client.getProjectSettings()).map(settings -> settings.subscribeOn(scheduler).cache()).orElse(Maybe.empty());
    }

    protected LaunchImpl(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters parameters, @Nonnull StartLaunchRQ rq, @Nonnull ExecutorService executorService, @Nonnull FlowableSubscriber<BatchSaveOperatingRS> loggingSubscriber) {
        super(reportPortalClient, parameters);
        Objects.requireNonNull(parameters, "Parameters shouldn't be NULL");
        this.executor = Objects.requireNonNull(executorService);
        if (this.executor.isShutdown()) {
            throw new InternalReportPortalClientException("Executor service is already shut down");
        }
        this.scheduler = this.createScheduler(this.executor);
        this.statisticsService = new StatisticsService(parameters);
        this.startRq = ObjectUtils.clonePojo(rq, StartLaunchRQ.class);
        this.truncateAttributes((StartRQ)this.startRq);
        LOGGER.info("Rerun: {}", (Object)parameters.isRerun());
        this.launch = LaunchImpl.getLaunchSupplier(this.getClient(), this.getScheduler(), this.startRq);
        this.logEmitter = LaunchImpl.getLogEmitter(this.getClient(), this.getParameters(), this.getScheduler(), loggingSubscriber);
        this.projectSettings = LaunchImpl.getProjectSettings(this.getClient(), this.getScheduler());
    }

    protected LaunchImpl(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters parameters, @Nonnull StartLaunchRQ rq, @Nonnull ExecutorService executorService) {
        this(reportPortalClient, parameters, rq, executorService, new LoggingSubscriber());
    }

    protected LaunchImpl(@Nonnull ReportPortalClient reportPortalClient, @Nonnull ListenerParameters parameters, @Nonnull Maybe<String> launchMaybe, @Nonnull ExecutorService executorService) {
        super(reportPortalClient, parameters);
        Objects.requireNonNull(parameters, "Parameters shouldn't be NULL");
        this.executor = Objects.requireNonNull(executorService);
        if (this.executor.isShutdown()) {
            throw new InternalReportPortalClientException("Executor service is already shut down");
        }
        this.scheduler = this.createScheduler(this.executor);
        this.statisticsService = new StatisticsService(parameters);
        this.startRq = LaunchImpl.emptyStartLaunchForStatistics();
        LOGGER.info("Rerun: {}", (Object)parameters.isRerun());
        this.launch = () -> launchMaybe.cache().subscribeOn(this.getScheduler());
        this.logEmitter = LaunchImpl.getLogEmitter(this.getClient(), this.getParameters(), this.getScheduler(), new LoggingSubscriber());
        this.projectSettings = LaunchImpl.getProjectSettings(this.getClient(), this.getScheduler());
    }

    private static StartLaunchRQ emptyStartLaunchForStatistics() {
        StartLaunchRQ result = new StartLaunchRQ();
        result.setAttributes(Collections.singleton(new ItemAttributesRQ(DefaultProperties.AGENT.getName(), CUSTOM_AGENT, true)));
        return result;
    }

    protected Scheduler createScheduler(ExecutorService executorService) {
        return SCHEDULERS.computeIfAbsent(executorService, Schedulers::from);
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    @Nonnull
    public Maybe<String> getLaunch() {
        return this.launch.get();
    }

    StatisticsService getStatisticsService() {
        return this.statisticsService;
    }

    private void truncateName(@Nonnull StartTestItemRQ rq) {
        if (!this.getParameters().isTruncateFields() || rq.getName() == null || rq.getName().isEmpty()) {
            return;
        }
        String name = rq.getName();
        int limit = this.getParameters().getTruncateItemNamesLimit();
        String replacement = this.getParameters().getTruncateReplacement();
        if (name.length() > limit && name.length() > replacement.length()) {
            rq.setName(name.substring(0, limit - replacement.length()) + replacement);
        }
    }

    @Nullable
    private Set<ItemAttributesRQ> truncateAttributes(@Nullable Set<ItemAttributesRQ> attributes) {
        if (!this.getParameters().isTruncateFields() || attributes == null || attributes.isEmpty()) {
            return attributes;
        }
        int limit = this.getParameters().getAttributeLengthLimit();
        String replacement = this.getParameters().getTruncateReplacement();
        return attributes.stream().map(attribute -> {
            int valueLength;
            ItemAttributesRQ updated = attribute;
            int keyLength = Optional.ofNullable(updated.getKey()).map(String::length).orElse(0);
            if (keyLength > limit && keyLength > replacement.length()) {
                updated = new ItemAttributesRQ(updated.getKey().substring(0, limit - replacement.length()) + replacement, updated.getValue(), updated.isSystem());
            }
            if ((valueLength = Optional.ofNullable(updated.getValue()).map(String::length).orElse(0).intValue()) > limit && valueLength > replacement.length()) {
                updated = new ItemAttributesRQ(updated.getKey(), updated.getValue().substring(0, limit - replacement.length()) + replacement, updated.isSystem());
            }
            return updated;
        }).collect(Collectors.toSet());
    }

    private void truncateAttributes(@Nonnull StartRQ rq) {
        rq.setAttributes(this.truncateAttributes(rq.getAttributes()));
    }

    private void truncateAttributes(@Nonnull FinishExecutionRQ rq) {
        rq.setAttributes(this.truncateAttributes(rq.getAttributes()));
    }

    public Completable completeLogEmitter() {
        Completable items = Completable.merge(this.logCompletables);
        this.logCompletables.clear();
        this.logEmitter.onComplete();
        return Completable.concat(Arrays.asList(items, this.logEmitter.ignoreElements()));
    }

    @Nonnull
    protected Maybe<String> start(boolean statistics) {
        if (this.getExecutor().isShutdown()) {
            throw new InternalReportPortalClientException("Executor service is already shut down");
        }
        ListenerParameters params = this.getParameters();
        Maybe<String> myLaunch = this.getLaunch();
        if (params.isPrintLaunchUuid()) {
            myLaunch.subscribe(SubscriptionUtils.printLaunch(params));
        } else {
            myLaunch.subscribe(SubscriptionUtils.logMaybeResults("Launch start"));
        }
        if (this.isShutDownHook.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> MultithreadingUtils.shutdownExecutorService(this.getExecutor(), this.getParameters().getReportingTimeout().intValue(), TimeUnit.SECONDS)));
        }
        if (statistics) {
            this.getStatisticsService().sendEvent(myLaunch, this.startRq);
        }
        return myLaunch;
    }

    @Override
    @Nonnull
    public Maybe<String> start() {
        return this.start(System.getenv(DISABLE_PROPERTY) == null);
    }

    protected Completable createVirtualItemCompletable() {
        if (this.virtualItems.isEmpty()) {
            return Completable.complete();
        }
        return Completable.timer((long)100L, (TimeUnit)TimeUnit.MILLISECONDS).andThen((CompletableSource)Completable.defer(this::createVirtualItemCompletable));
    }

    protected void waitForCompletable(Completable ... completableTasks) {
        if (completableTasks == null || completableTasks.length == 0) {
            return;
        }
        long timeoutInSeconds = this.getParameters().getReportingTimeout().intValue();
        try {
            Completable completable = completableTasks.length > 1 ? Completable.concatArray((CompletableSource[])completableTasks) : completableTasks[0];
            boolean result = completable.timeout(timeoutInSeconds, TimeUnit.SECONDS).blockingAwait(timeoutInSeconds, TimeUnit.SECONDS);
            if (!result) {
                LOGGER.error("Unable to finish launch items on ReportPortal. Timeout exceeded. The data may be lost.");
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to finish launch items on ReportPortal", (Throwable)e);
        }
    }

    protected void waitForItemsCompletion(Completable itemCompletable) {
        this.waitForCompletable(this.getLaunch().ignoreElement(), this.createVirtualItemCompletable(), itemCompletable, LoggingContext.completed(), this.completeLogEmitter());
    }

    @Override
    public void finish(FinishExecutionRQ request) {
        if (this.getExecutor().isShutdown()) {
            throw new InternalReportPortalClientException("Executor service is already shut down");
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        this.getStatisticsService().close();
        this.statisticsService = new StatisticsService(this.getParameters());
        Completable finish = Completable.concat((Iterable)this.queue.values().stream().flatMap(i -> i.getChildren().stream()).collect(Collectors.toList()));
        if (StringUtils.isBlank((CharSequence)this.getParameters().getLaunchUuid()) || !this.getParameters().isLaunchUuidCreationSkip()) {
            FinishExecutionRQ rq = ObjectUtils.clonePojo(request, FinishExecutionRQ.class);
            this.truncateAttributes(rq);
            finish = finish.andThen((MaybeSource)this.getLaunch().map(id -> (OperationCompletionRS)this.getClient().finishLaunch((String)id, rq).retry((Predicate)DEFAULT_REQUEST_RETRY).doOnSuccess(LaunchLoggingCallback.LOG_SUCCESS).doOnError(LaunchLoggingCallback.LOG_ERROR).blockingGet())).ignoreElement();
        }
        this.waitForItemsCompletion(finish.cache());
        this.virtualItemDisposables.removeIf(d -> {
            d.dispose();
            return true;
        });
    }

    private static <T> Maybe<T> createErrorResponse(Throwable cause) {
        LOGGER.error(cause.getMessage(), cause);
        return Maybe.error((Throwable)cause);
    }

    @Override
    @Nonnull
    public Maybe<String> startTestItem(StartTestItemRQ request) {
        if (request == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("StartTestItemRQ should not be null"));
        }
        StartTestItemRQ rq = ObjectUtils.clonePojo(request, StartTestItemRQ.class);
        this.truncateName(rq);
        this.truncateAttributes((StartRQ)rq);
        String itemDescription = String.format("root test item [%s] '%s'", rq.getType(), rq.getName());
        Maybe item = this.getLaunch().flatMap(launchId -> {
            rq.setLaunchUuid(launchId);
            LOGGER.trace("Starting {} in thread: {}", (Object)itemDescription, (Object)Thread.currentThread().getName());
            return this.getClient().startTestItem(rq).retry((Predicate)DEFAULT_REQUEST_RETRY).map(TO_ID);
        }).cache();
        item.subscribeOn(this.getScheduler()).subscribe(SubscriptionUtils.logMaybeResults("Start " + itemDescription));
        this.queue.getOrCompute((Maybe<String>)item).addToQueue(item.ignoreElement().onErrorComplete());
        LoggingContext.init((Maybe<String>)item);
        this.getStepReporter().setParent((Maybe<String>)item);
        return item;
    }

    @Override
    @Nonnull
    public Maybe<String> startTestItem(Maybe<String> parentId, Maybe<String> retryOf, StartTestItemRQ rq) {
        return retryOf.flatMap(s -> {
            StartTestItemRQ myRq = ObjectUtils.clonePojo(rq, StartTestItemRQ.class);
            myRq.setRetry(Boolean.valueOf(true));
            myRq.setRetryOf(s);
            return this.startTestItem(parentId, myRq);
        }).cache();
    }

    @Override
    @Nonnull
    public Maybe<String> startTestItem(Maybe<String> parentId, StartTestItemRQ request) {
        if (parentId == null) {
            return this.startTestItem(request);
        }
        if (request == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("StartTestItemRQ should not be null"));
        }
        StartTestItemRQ rq = ObjectUtils.clonePojo(request, StartTestItemRQ.class);
        this.truncateName(rq);
        this.truncateAttributes((StartRQ)rq);
        String itemDescription = String.format("child test item [%s] '%s'", rq.getType(), rq.getName());
        Maybe item = RxJavaPlugins.onAssembly((Maybe)Maybe.zip(this.getLaunch(), parentId, (lId, pId) -> {
            rq.setLaunchUuid(lId);
            LOGGER.trace("Starting {} in thread: {}", (Object)itemDescription, (Object)Thread.currentThread().getName());
            return this.getClient().startTestItem((String)pId, rq);
        }).flatMap(rs -> rs.retry((Predicate)DEFAULT_REQUEST_RETRY).map(TO_ID)).cache());
        item.subscribeOn(this.getScheduler()).subscribe(SubscriptionUtils.logMaybeResults("Start " + itemDescription));
        this.queue.getOrCompute((Maybe<String>)item).withParent(parentId).addToQueue(item.ignoreElement().onErrorComplete());
        LoggingContext.init((Maybe<String>)item);
        this.getStepReporter().setParent((Maybe<String>)item);
        return item;
    }

    @Override
    @Nonnull
    public Maybe<String> createVirtualItem() {
        PublishSubject emitter = PublishSubject.create();
        Maybe virtualItem = RxJavaPlugins.onAssembly((Maybe)emitter.singleElement().cache());
        this.virtualItems.put((Maybe<String>)virtualItem, (PublishSubject<String>)emitter);
        LoggingContext.init((Maybe<String>)virtualItem);
        return virtualItem;
    }

    private void populateVirtualItem(@Nonnull Maybe<String> virtualItem, @Nonnull String realId) {
        PublishSubject<String> emitter = this.virtualItems.remove(virtualItem);
        if (emitter != null) {
            emitter.onNext((Object)realId);
            emitter.onComplete();
        } else {
            LOGGER.error("Unable to populate virtual item with ID: {}. No emitter found.", (Object)realId);
        }
    }

    private void populateVirtualItem(@Nonnull Maybe<String> virtualItem, @Nonnull Throwable cause) {
        PublishSubject<String> emitter = this.virtualItems.remove(virtualItem);
        if (emitter != null) {
            emitter.onError(cause);
        } else {
            LOGGER.error("Unable to populate virtual item with error. No emitter found.", cause);
        }
    }

    private Maybe<String> handleVirtualItemError(Maybe<String> virtualItem, StartTestItemRQ request) {
        if (virtualItem == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("VirtualItem should not be null"));
        }
        if (request == null) {
            Maybe error = LaunchImpl.createErrorResponse(new NullPointerException("StartTestItemRQ should not be null"));
            Disposable errorDisposable = error.subscribe(id -> {}, e -> this.populateVirtualItem(virtualItem, (Throwable)e));
            this.virtualItemDisposables.add(errorDisposable);
            return error;
        }
        return null;
    }

    private void handleVirtualItemSubscription(Maybe<String> virtualItem, Maybe<String> item) {
        Disposable disposable = item.subscribe(id -> this.populateVirtualItem(virtualItem, (String)id), e -> {
            LOGGER.error("Unable to start test item.", e);
            this.populateVirtualItem(virtualItem, (Throwable)e);
        });
        this.virtualItemDisposables.add(disposable);
    }

    @Override
    @Nonnull
    public Maybe<String> startVirtualTestItem(Maybe<String> virtualItem, StartTestItemRQ rq) {
        Maybe<String> error = this.handleVirtualItemError(virtualItem, rq);
        if (error != null) {
            return error;
        }
        Maybe<String> item = this.startTestItem(rq);
        this.handleVirtualItemSubscription(virtualItem, item);
        return item;
    }

    @Override
    @Nonnull
    public Maybe<String> startVirtualTestItem(Maybe<String> parentId, Maybe<String> virtualItem, StartTestItemRQ rq) {
        Maybe<String> error = this.handleVirtualItemError(virtualItem, rq);
        if (error != null) {
            return error;
        }
        Maybe<String> item = this.startTestItem(parentId, rq);
        this.handleVirtualItemSubscription(virtualItem, item);
        return item;
    }

    protected void completeIssues(@Nonnull Issue issue) {
        String issueType = issue.getIssueType();
        if (StringUtils.isBlank((CharSequence)issueType)) {
            return;
        }
        Optional.ofNullable(this.projectSettings.blockingGet()).map(ProjectSettingsResource::getSubTypes).ifPresent(subTypes -> subTypes.values().stream().flatMap(Collection::stream).forEach(value -> {
            if (issueType.equals(value.getLocator())) {
                return;
            }
            if (issueType.equalsIgnoreCase(value.getShortName())) {
                issue.setIssueType(value.getLocator());
                return;
            }
            if (issueType.equalsIgnoreCase(value.getLongName())) {
                issue.setIssueType(value.getLocator());
                return;
            }
            if (issueType.equals(value.getTypeRef())) {
                issue.setIssueType(value.getLocator());
            }
        }));
        if (!Optional.ofNullable(issue.getExternalSystemIssues()).filter(issues -> !issues.isEmpty()).isPresent()) {
            return;
        }
        ListenerParameters params = this.getParameters();
        Optional<String> btsUrl = Optional.ofNullable(params.getBtsUrl()).filter(StringUtils::isNotBlank);
        Optional<String> btsProjectId = Optional.ofNullable(params.getBtsProjectId()).filter(StringUtils::isNotBlank);
        Optional<String> btsIssueUrl = Optional.ofNullable(params.getBtsIssueUrl()).filter(StringUtils::isNotBlank);
        issue.getExternalSystemIssues().stream().filter(Objects::nonNull).forEach(externalIssue -> {
            if (StringUtils.isBlank((CharSequence)externalIssue.getTicketId())) {
                return;
            }
            if (btsUrl.isPresent() && StringUtils.isBlank((CharSequence)externalIssue.getBtsUrl())) {
                externalIssue.setBtsUrl((String)btsUrl.get());
            }
            if (btsProjectId.isPresent() && StringUtils.isBlank((CharSequence)externalIssue.getBtsProject())) {
                externalIssue.setBtsProject((String)btsProjectId.get());
            }
            if (btsIssueUrl.isPresent() && StringUtils.isBlank((CharSequence)externalIssue.getUrl())) {
                externalIssue.setUrl((String)btsIssueUrl.get());
            }
            if (StringUtils.isNotBlank((CharSequence)externalIssue.getUrl())) {
                if (StringUtils.isNotBlank((CharSequence)externalIssue.getTicketId())) {
                    externalIssue.setUrl(externalIssue.getUrl().replace("{issue_id}", externalIssue.getTicketId()));
                }
                if (StringUtils.isNotBlank((CharSequence)externalIssue.getBtsProject())) {
                    externalIssue.setUrl(externalIssue.getUrl().replace("{bts_project}", externalIssue.getBtsProject()));
                }
            }
        });
    }

    @Override
    @Nonnull
    public Maybe<OperationCompletionRS> finishTestItem(Maybe<String> item, FinishTestItemRQ request) {
        TreeItem treeItem;
        if (item == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("ItemID should not be null"));
        }
        if (request == null) {
            return LaunchImpl.createErrorResponse(new NullPointerException("FinishTestItemRQ should not be null"));
        }
        FinishTestItemRQ rq = ObjectUtils.clonePojo(request, FinishTestItemRQ.class);
        this.truncateAttributes((FinishExecutionRQ)rq);
        this.getStepReporter().finishPreviousStep(Optional.ofNullable(rq.getStatus()).map(ItemStatus::valueOf).orElse(null));
        ItemStatus status = Optional.ofNullable(rq.getStatus()).map(ItemStatus::valueOf).orElse(null);
        if (rq.getIssue() == null) {
            if (status == ItemStatus.SKIPPED && !this.getParameters().getSkippedAnIssue().booleanValue()) {
                rq.setIssue(Launch.NOT_ISSUE);
            }
        } else if (status == ItemStatus.FAILED || status == ItemStatus.SKIPPED && this.getParameters().getSkippedAnIssue().booleanValue()) {
            this.completeIssues(rq.getIssue());
        } else if (status == ItemStatus.PASSED) {
            if (this.getParameters().isBtsIssueFail()) {
                rq.setStatus(ItemStatus.FAILED.name());
                rq.setIssue(StaticStructuresUtils.REDUNDANT_ISSUE);
            } else {
                rq.setIssue(null);
            }
        }
        if (null == (treeItem = (TreeItem)this.queue.get(item))) {
            treeItem = new TreeItem();
            LOGGER.error("Item {} not found in the cache", item);
        }
        if (this.getStepReporter().isFailed(item)) {
            rq.setStatus(ItemStatus.FAILED.name());
        }
        Maybe finishResponse = RxJavaPlugins.onAssembly((Maybe)Maybe.zip(this.getLaunch(), item, (launchId, itemId) -> {
            rq.setLaunchUuid(launchId);
            LOGGER.trace("Finishing test item {} in thread: {}", itemId, (Object)Thread.currentThread().getName());
            return this.getClient().finishTestItem((String)itemId, rq).retry((Predicate)TEST_ITEM_FINISH_REQUEST_RETRY).doOnSuccess(LaunchLoggingCallback.LOG_SUCCESS).doOnError(LaunchLoggingCallback.LOG_ERROR);
        }).flatMap(m -> m).cache());
        Completable finishCompletion = Completable.concat(treeItem.getChildren()).andThen((MaybeSource)finishResponse).doAfterTerminate(() -> {
            TreeItem cfr_ignored_0 = (TreeItem)this.queue.remove(item);
        }).ignoreElement().cache().subscribeOn(this.getScheduler());
        finishCompletion.subscribe(SubscriptionUtils.logCompletableResults("Finish test item"));
        Maybe<String> parent = treeItem.getParent();
        if (null != parent) {
            this.queue.getOrCompute(parent).addToQueue(finishCompletion.onErrorComplete());
        } else {
            this.queue.getOrCompute(this.getLaunch()).addToQueue(finishCompletion.onErrorComplete());
        }
        this.getStepReporter().removeParent(item);
        LoggingContext.dispose();
        int removeFactor = 100;
        if (rq.hashCode() % removeFactor == 0) {
            this.logCompletables.removeIf(c -> c.test().completions() > 0L);
        }
        return finishResponse;
    }

    private SaveLogRQ prepareRequest(@Nonnull SaveLogRQ rq) throws IOException {
        SaveLogRQ.File file = rq.getFile();
        if (this.getParameters().isConvertImage() && null != file && ImageConverter.isImage(file.getContentType())) {
            TypeAwareByteSource source = ImageConverter.convert(ByteSource.wrap(file.getContent()));
            file.setContent(source.read());
            file.setContentType(source.getMediaType());
        }
        return rq;
    }

    private SaveLogRQ prepareRequest(@Nonnull String launchId, @Nonnull SaveLogRQ rq) throws IOException {
        rq.setLaunchUuid(launchId);
        return this.prepareRequest(rq);
    }

    private void emitLog(@Nonnull SaveLogRQ rq) {
        this.logEmitter.onNext((Object)rq);
    }

    @Override
    public void log(@Nonnull SaveLogRQ rq) {
        Maybe result = this.getLaunch().map(launchUuid -> {
            this.emitLog(this.prepareRequest((String)launchUuid, rq));
            return rq;
        }).cache();
        this.logCompletables.add(result.ignoreElement());
        result.subscribe(SubscriptionUtils.logMaybeResults("Log item"));
    }

    @Override
    public void log(@Nonnull java.util.function.Function<String, SaveLogRQ> logSupplier) {
        Maybe result = this.getLaunch().map(launchUuid -> {
            SaveLogRQ rq = this.prepareRequest((SaveLogRQ)logSupplier.apply((String)launchUuid));
            this.emitLog(rq);
            return rq;
        }).cache();
        this.logCompletables.add(result.ignoreElement());
        result.subscribe(SubscriptionUtils.logMaybeResults("Log item"));
    }

    protected static class ComputationConcurrentHashMap
    extends ConcurrentHashMap<Maybe<String>, TreeItem> {
        protected ComputationConcurrentHashMap() {
        }

        public TreeItem getOrCompute(Maybe<String> key) {
            return this.computeIfAbsent(key, k -> new TreeItem());
        }
    }

    protected static class TreeItem {
        private volatile Maybe<String> parent;
        private final List<Completable> children = new CopyOnWriteArrayList<Completable>();

        protected TreeItem() {
        }

        public TreeItem withParent(@Nullable Maybe<String> parent) {
            this.parent = parent;
            return this;
        }

        public void addToQueue(@Nonnull Completable completable) {
            this.children.add(completable);
        }

        @Nonnull
        public List<Completable> getChildren() {
            return new ArrayList<Completable>(this.children);
        }

        @Nullable
        public Maybe<String> getParent() {
            return this.parent;
        }
    }
}

