/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.step;

import com.epam.reportportal.listeners.ItemStatus;
import com.epam.reportportal.listeners.LogLevel;
import com.epam.reportportal.message.TypeAwareByteSource;
import com.epam.reportportal.service.Launch;
import com.epam.reportportal.service.ReportPortal;
import com.epam.reportportal.service.step.StepReporter;
import com.epam.reportportal.service.step.StepRequestUtils;
import com.epam.reportportal.utils.ObjectUtils;
import com.epam.reportportal.utils.StatusEvaluation;
import com.epam.reportportal.utils.files.Utils;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.FinishTestItemRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.StartTestItemRQ;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import io.reactivex.Maybe;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStepReporter
implements StepReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultStepReporter.class);
    private final ThreadLocal<Deque<Maybe<String>>> stepStack = ThreadLocal.withInitial(ConcurrentLinkedDeque::new);
    private final Map<Maybe<String>, StepReporter.StepEntry> steps = new ConcurrentHashMap<Maybe<String>, StepReporter.StepEntry>();
    private final Deque<Maybe<String>> imperativeSteps = new ConcurrentLinkedDeque<Maybe<String>>();
    private final Set<Maybe<String>> parentFailures = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Launch launch;

    public DefaultStepReporter(Launch currentLaunch) {
        this.launch = currentLaunch;
    }

    private Deque<Maybe<String>> getParentStack() {
        return this.stepStack.get();
    }

    @Override
    @Nullable
    public Maybe<String> getParent() {
        return this.getParentStack().peekLast();
    }

    @Override
    public void setStepStatus(@Nonnull ItemStatus status) {
        Optional.ofNullable(this.steps.get(this.getParent())).ifPresent(step -> step.getFinishTestItemRQ().setStatus(status.name()));
    }

    @Override
    public void setParent(@Nullable Maybe<String> parentUuid) {
        if (parentUuid != null) {
            this.getParentStack().add(parentUuid);
        }
    }

    @Override
    public void removeParent(@Nullable Maybe<String> parentUuid) {
        if (parentUuid != null) {
            this.getParentStack().removeLastOccurrence(parentUuid);
            this.parentFailures.remove(parentUuid);
        }
    }

    @Override
    public boolean isFailed(@Nullable Maybe<String> parentId) {
        if (parentId != null) {
            return this.parentFailures.contains(parentId);
        }
        return false;
    }

    @Nonnull
    protected Maybe<String> sendStep(@Nonnull ItemStatus status, @Nonnull String name, @Nullable Runnable actions) {
        StartTestItemRQ rq = this.buildStartStepRequest(name);
        Maybe<String> stepId = this.startStepRequest(rq);
        this.imperativeSteps.add(stepId);
        if (actions != null) {
            try {
                actions.run();
            }
            catch (Throwable e) {
                LOGGER.error("Unable to process nested step: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
        this.addStepEntry(stepId, status, rq.getStartTime());
        return stepId;
    }

    @Override
    @Nonnull
    public Maybe<String> sendStep(@Nonnull ItemStatus status, @Nonnull String name) {
        return this.sendStep(status, name, () -> {});
    }

    @Override
    @Nonnull
    public Maybe<String> sendStep(@Nonnull String name) {
        return this.sendStep(ItemStatus.PASSED, name);
    }

    @Override
    @Nonnull
    public Maybe<String> sendStep(@Nonnull ItemStatus status, @Nonnull String name, String ... logs) {
        Runnable actions = Optional.ofNullable(logs).map(l -> () -> Arrays.stream(l).forEach(log -> ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, (String)log, LogLevel.INFO)))).orElse(null);
        return this.sendStep(status, name, actions);
    }

    @Override
    @Nonnull
    public Maybe<String> sendStep(@Nonnull String name, String ... logs) {
        return this.sendStep(ItemStatus.PASSED, name, logs);
    }

    @Override
    @Nonnull
    public Maybe<String> sendStep(@Nonnull ItemStatus status, @Nonnull String name, Throwable throwable) {
        return this.sendStep(status, name, () -> ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, throwable)));
    }

    @Override
    @Nonnull
    public Maybe<String> sendStep(@Nonnull ItemStatus status, @Nonnull String name, File ... files) {
        Runnable actions = Optional.ofNullable(files).map(f -> () -> Arrays.stream(f).forEach(file -> ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, "", LogLevel.INFO, (File)file)))).orElse(null);
        return this.sendStep(status, name, actions);
    }

    @Override
    @Nonnull
    public Maybe<String> sendStep(@Nonnull String name, File ... files) {
        return this.sendStep(ItemStatus.PASSED, name, files);
    }

    @Override
    @Nonnull
    public Maybe<String> sendStep(@Nonnull ItemStatus status, @Nonnull String name, Throwable throwable, File ... files) {
        return this.sendStep(status, name, () -> {
            for (File file : files) {
                ReportPortal.emitLog(itemId -> this.buildSaveLogRequest((String)itemId, throwable, file));
            }
        });
    }

    private Optional<StepReporter.StepEntry> finishPreviousStepInternal(@Nullable ItemStatus finishStatus) {
        return Optional.ofNullable(this.imperativeSteps.pollLast()).map(this.steps::remove).map(stepEntry -> {
            FinishTestItemRQ finishRq = stepEntry.getFinishTestItemRQ();
            ItemStatus status = StatusEvaluation.evaluateStatus(Optional.ofNullable(finishRq.getStatus()).map(ItemStatus::valueOf).orElse(ItemStatus.PASSED), finishStatus);
            Optional.ofNullable(status).ifPresent(s -> finishRq.setStatus(s.name()));
            this.launch.finishTestItem(stepEntry.getItemId(), finishRq);
            return stepEntry;
        });
    }

    private void failParents() {
        this.parentFailures.addAll(this.getParentStack());
    }

    @Override
    @Nonnull
    public Maybe<String> finishPreviousStep(@Nullable ItemStatus status) {
        return this.finishPreviousStepInternal(status).map(e -> {
            if (ItemStatus.FAILED.name().equalsIgnoreCase(e.getFinishTestItemRQ().getStatus())) {
                this.failParents();
            }
            return e.getItemId();
        }).orElse(Maybe.empty());
    }

    @Override
    @Nonnull
    public Maybe<String> finishPreviousStep() {
        return this.finishPreviousStep(null);
    }

    @Override
    @Nonnull
    public Maybe<String> startNestedStep(@Nonnull StartTestItemRQ startStepRequest) {
        Maybe<String> parent = this.getParent();
        if (parent == null) {
            LOGGER.warn("Unable to find parent ID, skipping step: {}", (Object)startStepRequest.getName());
            return Maybe.empty();
        }
        Maybe<String> itemId = this.launch.startTestItem(parent, startStepRequest);
        this.steps.put(itemId, new StepReporter.StepEntry(itemId, new FinishTestItemRQ()));
        return itemId;
    }

    @Override
    @Nonnull
    public Maybe<OperationCompletionRS> finishNestedStep(@Nonnull FinishTestItemRQ finishStepRequest) {
        Maybe<String> stepId = this.getParent();
        if (stepId == null) {
            LOGGER.warn("Unable to find item ID, skipping step a finish step");
            return Maybe.empty();
        }
        StepReporter.StepEntry manualRequest = this.steps.remove(stepId);
        String manualStatus = Optional.ofNullable(manualRequest).map(StepReporter.StepEntry::getFinishTestItemRQ).map(FinishExecutionRQ::getStatus).orElse(null);
        String runStatus = Optional.ofNullable(finishStepRequest.getStatus()).orElse(ItemStatus.PASSED.name());
        FinishTestItemRQ actualRequest = ObjectUtils.clonePojo(finishStepRequest, FinishTestItemRQ.class);
        if (manualStatus != null) {
            actualRequest.setStatus(manualStatus);
            if (ItemStatus.FAILED.name().equalsIgnoreCase(manualStatus)) {
                this.failParents();
            }
        } else {
            actualRequest.setStatus(runStatus);
        }
        actualRequest.setStatus(Optional.ofNullable(manualStatus).orElse(runStatus));
        return this.launch.finishTestItem(stepId, actualRequest);
    }

    @Override
    @Nonnull
    public Maybe<OperationCompletionRS> finishNestedStep(@Nonnull ItemStatus status) {
        FinishTestItemRQ finishStepRequest = StepRequestUtils.buildFinishTestItemRequest(status);
        return this.finishNestedStep(finishStepRequest);
    }

    @Override
    @Nonnull
    public Maybe<OperationCompletionRS> finishNestedStep() {
        return this.finishNestedStep(ItemStatus.PASSED);
    }

    @Override
    @Nonnull
    public Maybe<OperationCompletionRS> finishNestedStep(@Nullable Throwable throwable) {
        ReportPortal.emitLog(itemUuid -> this.buildSaveLogRequest((String)itemUuid, throwable));
        return this.finishNestedStep(ItemStatus.FAILED);
    }

    @Override
    @Nonnull
    public Maybe<String> step(@Nonnull ItemStatus status, @Nonnull String name) {
        Maybe<String> itemId = this.startNestedStep(this.buildStartStepRequest(name));
        return this.finishNestedStep(status).flatMap(finishRs -> itemId);
    }

    @Override
    @Nonnull
    public Maybe<String> step(@Nonnull String name) {
        return this.step(ItemStatus.PASSED, name);
    }

    @Override
    @Nullable
    public <T> T step(@Nonnull ItemStatus stepSuccessStatus, @Nonnull String name, @Nonnull Supplier<T> actions) {
        this.startNestedStep(this.buildStartStepRequest(name));
        try {
            T result = actions.get();
            this.finishNestedStep(stepSuccessStatus);
            return result;
        }
        catch (Error | RuntimeException e) {
            this.finishNestedStep(ItemStatus.FAILED);
            throw e;
        }
    }

    @Override
    @Nullable
    public <T> T step(@Nonnull String name, @Nonnull Supplier<T> actions) {
        return this.step(ItemStatus.PASSED, name, actions);
    }

    @Nonnull
    private Maybe<String> startStepRequest(StartTestItemRQ startTestItemRQ) {
        this.finishPreviousStepInternal(null).ifPresent(e -> {
            Date currentDate;
            Date previousDate = e.getTimestamp();
            if (!previousDate.before(currentDate = startTestItemRQ.getStartTime())) {
                startTestItemRQ.setStartTime(new Date(previousDate.getTime() + 1L));
            }
            if (ItemStatus.FAILED.name().equalsIgnoreCase(e.getFinishTestItemRQ().getStatus())) {
                this.failParents();
            }
        });
        return this.startNestedStep(startTestItemRQ);
    }

    private StartTestItemRQ buildStartStepRequest(@Nonnull String name) {
        StartTestItemRQ startTestItemRQ = new StartTestItemRQ();
        startTestItemRQ.setName(name);
        startTestItemRQ.setType("STEP");
        startTestItemRQ.setHasStats(false);
        startTestItemRQ.setStartTime(Calendar.getInstance().getTime());
        return startTestItemRQ;
    }

    private void addStepEntry(Maybe<String> stepId, ItemStatus status, Date timestamp) {
        FinishTestItemRQ finishTestItemRQ = StepRequestUtils.buildFinishTestItemRequest(status);
        this.steps.put(stepId, new StepReporter.StepEntry(stepId, timestamp, finishTestItemRQ));
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, String message, LogLevel level) {
        SaveLogRQ rq = new SaveLogRQ();
        rq.setItemUuid(itemId);
        rq.setMessage(message);
        rq.setLevel(level.name());
        rq.setLogTime(Calendar.getInstance().getTime());
        return rq;
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, String message, LogLevel level, File file) {
        SaveLogRQ logRQ = this.buildSaveLogRequest(itemId, message, level);
        if (file != null) {
            try {
                logRQ.setFile(this.createFileModel(file));
            }
            catch (IOException e) {
                LOGGER.error("Unable to read file attachment: {}", (Object)e.getMessage(), (Object)e);
            }
        }
        return logRQ;
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, Throwable throwable, File file) {
        String message = throwable != null ? ExceptionUtils.getStackTrace((Throwable)throwable) : "Test has failed without exception";
        return this.buildSaveLogRequest(itemId, message, LogLevel.ERROR, file);
    }

    private SaveLogRQ buildSaveLogRequest(String itemId, Throwable throwable) {
        return this.buildSaveLogRequest(itemId, throwable, null);
    }

    private SaveLogRQ.File createFileModel(File file) throws IOException {
        TypeAwareByteSource dataSource = Utils.getFile(file);
        SaveLogRQ.File fileModel = new SaveLogRQ.File();
        fileModel.setContent(dataSource.read());
        fileModel.setContentType(dataSource.getMediaType());
        fileModel.setName(UUID.randomUUID().toString());
        return fileModel;
    }
}

