/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.service.launch;

import com.epam.reportportal.service.LaunchIdLock;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.Callable;

public class SecondaryLaunchFinishCondition
implements Callable<Boolean> {
    private volatile Collection<String> launches;
    private final LaunchIdLock lock;
    private final String uuid;

    public SecondaryLaunchFinishCondition(LaunchIdLock launchIdLock, String selfUuid) {
        this.lock = launchIdLock;
        this.uuid = selfUuid;
    }

    @Override
    public Boolean call() {
        Collection<String> current = this.lock.getLiveInstanceUuids();
        if (current.isEmpty() || current.size() == 1 && this.uuid.equals(current.iterator().next())) {
            return true;
        }
        Boolean changed = Optional.ofNullable(this.launches).map(l -> !l.equals(current)).orElse(Boolean.TRUE);
        this.launches = current;
        if (changed.booleanValue()) {
            return false;
        }
        return null;
    }
}

