/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class BasicUtils {
    private BasicUtils() {
        throw new IllegalStateException("Static only class");
    }

    @Nonnull
    public static String truncateString(@Nonnull String string, int limit, @Nullable String truncateReplacement) {
        String replacement;
        int effectiveLimit = Math.max(0, limit);
        if (string.length() <= effectiveLimit) {
            return string;
        }
        if (effectiveLimit == 0) {
            return "";
        }
        String string2 = replacement = truncateReplacement == null ? "..." : truncateReplacement;
        if (effectiveLimit <= replacement.length()) {
            return string.substring(0, effectiveLimit);
        }
        return string.substring(0, effectiveLimit - replacement.length()) + replacement;
    }

    public static int compareSemanticVersions(@Nonnull String compared, @Nonnull String basic) {
        String[] basePreBasic;
        String comparedNorm = BasicUtils.normalizeVersion(compared);
        String basicNorm = BasicUtils.normalizeVersion(basic);
        String[] basePreCompared = BasicUtils.splitBaseAndPreRelease(comparedNorm);
        int coreCompare = BasicUtils.compareCoreVersions(basePreCompared[0], (basePreBasic = BasicUtils.splitBaseAndPreRelease(basicNorm))[0]);
        if (coreCompare != 0) {
            return coreCompare;
        }
        String pre1 = basePreCompared[1];
        String pre2 = basePreBasic[1];
        if (Objects.equals(pre1, pre2)) {
            return 0;
        }
        if (pre1 == null) {
            return 1;
        }
        if (pre2 == null) {
            return -1;
        }
        return BasicUtils.comparePreRelease(pre1, pre2);
    }

    @Nonnull
    private static String normalizeVersion(@Nonnull String version) {
        int plusIdx;
        String v = version.trim();
        if (v.startsWith("v") || v.startsWith("V")) {
            v = v.substring(1);
        }
        if ((plusIdx = v.indexOf(43)) >= 0) {
            v = v.substring(0, plusIdx);
        }
        return v;
    }

    @Nonnull
    private static String[] splitBaseAndPreRelease(@Nonnull String version) {
        int dashIdx = version.indexOf(45);
        if (dashIdx < 0) {
            return new String[]{version, null};
        }
        return new String[]{version.substring(0, dashIdx), version.substring(dashIdx + 1)};
    }

    private static int compareCoreVersions(@Nonnull String core1, @Nonnull String core2) {
        String[] p1 = core1.split("\\.");
        String[] p2 = core2.split("\\.");
        int len = Math.max(p1.length, p2.length);
        for (int i = 0; i < len; ++i) {
            long n2;
            long n1 = i < p1.length ? BasicUtils.parseLongSafe(p1[i]) : 0L;
            long l = n2 = i < p2.length ? BasicUtils.parseLongSafe(p2[i]) : 0L;
            if (n1 == n2) continue;
            return n1 < n2 ? -1 : 1;
        }
        return 0;
    }

    private static int comparePreRelease(@Nonnull String pre1, @Nonnull String pre2) {
        String[] t1 = pre1.split("\\.");
        String[] t2 = pre2.split("\\.");
        int len = Math.max(t1.length, t2.length);
        for (int i = 0; i < len; ++i) {
            String b;
            String a = i < t1.length ? t1[i] : null;
            String string = b = i < t2.length ? t2[i] : null;
            if (Objects.equals(a, b)) continue;
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            boolean aNum = BasicUtils.isNumeric(a);
            boolean bNum = BasicUtils.isNumeric(b);
            if (aNum && bNum) {
                long nb;
                long na = BasicUtils.parseLongSafe(a);
                if (na == (nb = BasicUtils.parseLongSafe(b))) continue;
                return na < nb ? -1 : 1;
            }
            if (aNum != bNum) {
                return aNum ? -1 : 1;
            }
            int cmp = a.compareTo(b);
            if (cmp == 0) continue;
            return cmp < 0 ? -1 : 1;
        }
        return 0;
    }

    private static long parseLongSafe(@Nonnull String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    private static boolean isNumeric(@Nonnull String s) {
        if (s.isEmpty()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

