/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

public class MemoizingSupplier<T>
implements Supplier<T>,
Serializable {
    private final ReentrantLock lock = new ReentrantLock();
    private final Supplier<T> delegate;
    private volatile transient boolean initialized;
    private volatile transient T value;
    private static final long serialVersionUID = 0L;

    public MemoizingSupplier(@Nonnull Supplier<T> delegate) {
        Objects.requireNonNull(delegate);
        this.delegate = delegate;
    }

    @Override
    public T get() {
        if (!this.initialized) {
            this.lock.lock();
            try {
                if (!this.initialized) {
                    this.value = this.delegate.get();
                    this.initialized = true;
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.value;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void reset() {
        this.initialized = false;
    }

    public String toString() {
        return "MemoizingSupplier(" + String.valueOf(this.delegate) + ")";
    }
}

