/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import com.epam.reportportal.listeners.ListenerParameters;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultithreadingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultithreadingUtils.class);

    public static ExecutorService buildExecutorService(String namePrefix, int threadCount) {
        AtomicLong threadCounter = new AtomicLong();
        ThreadFactory threadFactory = r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.setName(namePrefix + threadCounter.incrementAndGet());
            return t;
        };
        return Executors.newFixedThreadPool(threadCount, threadFactory);
    }

    public static ExecutorService buildExecutorService(String namePrefix, ListenerParameters params) {
        return MultithreadingUtils.buildExecutorService(namePrefix, params.getIoPoolSize());
    }

    public static void shutdownExecutorService(@Nonnull ExecutorService executorService, long duration, @Nonnull TimeUnit timeUnit) {
        if (!executorService.isShutdown()) {
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(duration, timeUnit)) {
                    LOGGER.warn("Executor service did not terminate in the specified time. Force shutting down.");
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOGGER.warn("Executor service was interrupted during shutdown. Force shutting down.");
                executorService.shutdownNow();
            }
        }
    }
}

