/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model;

import com.epam.ta.reportportal.ws.model.ErrorType;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.IOException;

@JsonPropertyOrder(value={"errorCode", "message", "stackTrace"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ErrorRS {
    @JsonSerialize(using=ErrorTypeSerializer.class)
    @JsonDeserialize(using=ErrorTypeDeserializer.class)
    @JsonProperty(value="errorCode")
    private ErrorType errorType;
    @JsonProperty(value="stackTrace")
    private String stackTrace;
    @JsonProperty(value="message")
    private String message;

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public void setErrorType(ErrorType errorType) {
        this.errorType = errorType;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String stackTrace) {
        this.stackTrace = stackTrace;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private static class ErrorTypeSerializer
    extends JsonSerializer<ErrorType> {
        private ErrorTypeSerializer() {
        }

        public void serialize(ErrorType error, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(error.getCode());
        }
    }

    private static class ErrorTypeDeserializer
    extends JsonDeserializer<ErrorType> {
        private ErrorTypeDeserializer() {
        }

        public ErrorType deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            return ErrorType.getByCode(node.asInt());
        }
    }
}

