/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils;

import io.reactivex.functions.Predicate;
import jakarta.annotation.Nonnull;

public class RetryWithDelay
implements Predicate<Throwable> {
    private final Predicate<? super Throwable> predicate;
    private final long maxRetries;
    private final long retryDelayMillis;
    private int retryCount;

    public RetryWithDelay(Predicate<? super Throwable> predicate, long maxRetries, long retryDelayMillis) {
        this.maxRetries = maxRetries;
        this.retryDelayMillis = retryDelayMillis;
        this.retryCount = 0;
        this.predicate = predicate;
    }

    public boolean test(@Nonnull Throwable throwable) throws Exception {
        try {
            if (!this.predicate.test((Object)throwable)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        if ((long)(++this.retryCount) < this.maxRetries) {
            Thread.sleep(this.retryDelayMillis);
            return true;
        }
        return false;
    }
}

