/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.http;

import com.epam.reportportal.exception.InternalReportPortalClientException;
import com.epam.reportportal.listeners.ListenerParameters;
import com.epam.reportportal.service.BearerAuthInterceptor;
import com.epam.reportportal.service.OAuth2PasswordGrantAuthInterceptor;
import com.epam.reportportal.utils.SslUtils;
import jakarta.annotation.Nonnull;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientUtils.class);
    private static final String HTTPS = "https";

    private ClientUtils() {
        throw new IllegalStateException("Static only class");
    }

    @Nonnull
    public static OkHttpClient.Builder setupProxy(@Nonnull OkHttpClient.Builder builder, @Nonnull ListenerParameters parameters) {
        URL proxyUrl;
        String proxyStr = parameters.getProxyUrl();
        if (StringUtils.isBlank((CharSequence)proxyStr)) {
            return builder;
        }
        try {
            proxyUrl = new URL(proxyStr);
        }
        catch (MalformedURLException e) {
            throw new InternalReportPortalClientException("Unable to parse proxy URL", e);
        }
        int port = proxyUrl.getPort();
        builder.proxy(new Proxy(Proxy.Type.HTTP, InetSocketAddress.createUnresolved(proxyUrl.getHost(), port >= 0 ? port : proxyUrl.getDefaultPort())));
        String proxyUser = parameters.getProxyUser();
        if (StringUtils.isNotBlank((CharSequence)proxyUser)) {
            builder.proxyAuthenticator((route, response) -> {
                String credential = Credentials.basic((String)proxyUser, (String)parameters.getProxyPassword(), (Charset)StandardCharsets.UTF_8);
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            });
        }
        return builder;
    }

    @Nonnull
    public static OkHttpClient.Builder setupSsl(@Nonnull OkHttpClient.Builder builder, URL baseUrl, @Nonnull ListenerParameters parameters) {
        String keyStore = parameters.getKeystore();
        String keyStorePassword = parameters.getKeystorePassword();
        String trustStore = parameters.getTruststore();
        String trustStorePassword = parameters.getTruststorePassword();
        if (HTTPS.equals(baseUrl.getProtocol()) && (keyStore != null || trustStore != null)) {
            KeyManager[] keyManagers = null;
            if (keyStore != null) {
                KeyStore ks = SslUtils.loadKeyStore(keyStore, keyStorePassword, parameters.getKeystoreType());
                try {
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(ks, Optional.ofNullable(keyStorePassword).map(String::toCharArray).orElse(null));
                    keyManagers = kmf.getKeyManagers();
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    String error = "Unable to load key store";
                    LOGGER.error(error, (Throwable)e);
                    throw new InternalReportPortalClientException(error, e);
                }
            }
            TrustManager[] trustManagers = null;
            if (trustStore != null) {
                KeyStore ts = SslUtils.loadKeyStore(trustStore, trustStorePassword, parameters.getTruststoreType());
                try {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ts);
                    trustManagers = tmf.getTrustManagers();
                }
                catch (KeyStoreException | NoSuchAlgorithmException e) {
                    String trustStoreError = "Unable to load trust store";
                    LOGGER.error(trustStoreError, (Throwable)e);
                    throw new InternalReportPortalClientException(trustStoreError, e);
                }
            }
            if (trustManagers == null) {
                try {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init((KeyStore)null);
                    trustManagers = tmf.getTrustManagers();
                }
                catch (KeyStoreException | NoSuchAlgorithmException e) {
                    String trustStoreError = "Unable to load default trust store";
                    LOGGER.error(trustStoreError, (Throwable)e);
                    throw new InternalReportPortalClientException(trustStoreError, e);
                }
            }
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(keyManagers, trustManagers, new SecureRandom());
                X509TrustManager trustManager = Arrays.stream(Optional.ofNullable(trustManagers).orElse(new TrustManager[0])).filter(m -> m instanceof X509TrustManager).map(m -> (X509TrustManager)m).findAny().orElseThrow(() -> new InternalReportPortalClientException("Unable to find X509 trust manager"));
                builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                String error = "Unable to initialize SSL context";
                LOGGER.error(error, (Throwable)e);
                throw new InternalReportPortalClientException(error, e);
            }
        }
        return builder;
    }

    private static boolean isOAuthConfigured(@Nonnull ListenerParameters parameters) {
        return StringUtils.isNotBlank((CharSequence)parameters.getOauthTokenUri()) && StringUtils.isNotBlank((CharSequence)parameters.getOauthUsername()) && StringUtils.isNotBlank((CharSequence)parameters.getOauthPassword()) && StringUtils.isNotBlank((CharSequence)parameters.getOauthClientId());
    }

    @Nonnull
    private static Interceptor createAuthInterceptor(@Nonnull ListenerParameters parameters) {
        if (ClientUtils.isOAuthConfigured(parameters)) {
            return new OAuth2PasswordGrantAuthInterceptor(parameters);
        }
        if (StringUtils.isNotBlank((CharSequence)parameters.getApiKey())) {
            return new BearerAuthInterceptor(parameters.getApiKey());
        }
        throw new InternalReportPortalClientException("Neither OAuth 2.0 nor API key authentication is configured");
    }

    @Nonnull
    public static OkHttpClient.Builder setupAuthInterceptor(@Nonnull OkHttpClient.Builder builder, @Nonnull ListenerParameters parameters) {
        return builder.addInterceptor(ClientUtils.createAuthInterceptor(parameters));
    }

    @Nonnull
    public static OkHttpClient.Builder setupHttpLoggingInterceptor(@Nonnull OkHttpClient.Builder builder, @Nonnull ListenerParameters parameters) {
        if (!parameters.isHttpLogging()) {
            return builder;
        }
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        return builder.addNetworkInterceptor((Interceptor)logging);
    }
}

