/*
 * Decompiled with CFR 0.152.
 */
package com.epam.reportportal.utils.serialize;

import com.epam.reportportal.utils.serialize.TimeSerializer;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Date;

public class TimeDeserializer
extends JsonDeserializer<Comparable<?>> {
    public Comparable<? extends Comparable<?>> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken token = p.getCurrentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token == JsonToken.VALUE_NUMBER_INT || token == JsonToken.VALUE_NUMBER_FLOAT) {
            long timestamp = p.getLongValue();
            return new Date(timestamp);
        }
        if (token == JsonToken.VALUE_STRING) {
            String value = p.getText();
            if (value.isBlank()) {
                return null;
            }
            try {
                return TimeSerializer.ISO_MICRO_FORMATTER.parse((CharSequence)value, Instant::from);
            }
            catch (DateTimeParseException e1) {
                try {
                    return Instant.parse(value);
                }
                catch (DateTimeParseException e2) {
                    try {
                        long timestamp = Long.parseLong(value);
                        return new Date(timestamp);
                    }
                    catch (NumberFormatException nfe) {
                        throw new IOException("Unable to parse time value: " + value, nfe);
                    }
                }
            }
        }
        throw new IOException("Unexpected token for time deserialization: " + String.valueOf(token));
    }
}

