/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model;

import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartRQ;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StartTestItemRQ
extends StartRQ {
    @Valid
    @JsonProperty(value="parameters")
    private List<ParameterResource> parameters;
    @JsonProperty(value="uniqueId")
    private String uniqueId;
    @NotNull
    @JsonProperty(value="launch_id", required=true)
    @ApiModelProperty(required=true)
    private String launchId;
    @NotNull
    @JsonProperty(value="type", required=true)
    @JsonSerialize(using=UpperCaseTypeSerializer.class)
    @JsonDeserialize(using=UpperCaseTypeDeserializer.class)
    @ApiModelProperty(required=true, allowableValues="SUITE, STORY, TEST, SCENARIO, STEP, BEFORE_CLASS, BEFORE_GROUPS,BEFORE_METHOD, BEFORE_SUITE, BEFORE_TEST, AFTER_CLASS, AFTER_GROUPS, AFTER_METHOD, AFTER_SUITE, AFTER_TEST")
    private String type;
    @JsonProperty(value="retry")
    private Boolean retry;

    public Boolean isRetry() {
        return this.retry;
    }

    public void setRetry(Boolean retry) {
        this.retry = retry;
    }

    public String getLaunchId() {
        return this.launchId;
    }

    public void setLaunchId(String launchId) {
        this.launchId = launchId;
    }

    public List<ParameterResource> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterResource> parameters) {
        this.parameters = parameters;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StartTestItemRQ{");
        sb.append("parameters=").append(this.parameters);
        sb.append(", uniqueId='").append(this.uniqueId).append('\'');
        sb.append(", launchId='").append(this.launchId).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append(", retry=").append(this.retry);
        sb.append('}');
        return sb.toString();
    }

    private static class UpperCaseTypeSerializer
    extends JsonSerializer<String> {
        private UpperCaseTypeSerializer() {
        }

        public void serialize(String type, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (type != null) {
                jsonGenerator.writeString(type.toUpperCase());
            }
        }
    }

    private static class UpperCaseTypeDeserializer
    extends JsonDeserializer<String> {
        private UpperCaseTypeDeserializer() {
        }

        public String deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            return node.asText().toUpperCase();
        }
    }
}

