/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model;

import com.epam.ta.reportportal.ws.annotations.In;
import com.epam.ta.reportportal.ws.annotations.NotBlankWithSize;
import com.epam.ta.reportportal.ws.model.ParameterResource;
import com.epam.ta.reportportal.ws.model.StartRQ;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class StartTestItemRQ
extends StartRQ {
    @JsonProperty(value="codeRef")
    private String codeRef;
    @Valid
    @JsonProperty(value="parameters")
    private List<ParameterResource> parameters;
    @Size(max=1024)
    @JsonProperty(value="uniqueId")
    private @Size(max=1024) String uniqueId;
    @JsonProperty(value="testCaseId")
    private String testCaseId;
    @JsonProperty(value="testCaseHash")
    private Integer testCaseHash;
    @NotNull
    @JsonAlias(value={"launchUuid", "launch_id"})
    @ApiModelProperty(value="UUID of parent launch", required=true)
    private String launchUuid;
    @NotNull
    @JsonProperty(value="type", required=true)
    @JsonSerialize(using=UpperCaseTypeSerializer.class)
    @JsonDeserialize(using=UpperCaseTypeDeserializer.class)
    @In(allowedValues={"suite", "story", "test", "scenario", "step", "before_class", "before_groups", "before_method", "before_suite", "before_test", "after_class", "after_groups", "after_method", "after_suite", "after_test"})
    @ApiModelProperty(required=true, allowableValues="SUITE, STORY, TEST, SCENARIO, STEP, BEFORE_CLASS, BEFORE_GROUPS,BEFORE_METHOD, BEFORE_SUITE, BEFORE_TEST, AFTER_CLASS, AFTER_GROUPS, AFTER_METHOD, AFTER_SUITE, AFTER_TEST")
    private String type;
    @JsonProperty(value="retry")
    private Boolean retry;
    @JsonProperty(value="hasStats")
    private boolean hasStats = true;

    @Override
    @NotBlankWithSize(min=1, max=1024)
    public String getName() {
        return this.name;
    }

    public String getCodeRef() {
        return this.codeRef;
    }

    public void setCodeRef(String codeRef) {
        this.codeRef = codeRef;
    }

    public Boolean isRetry() {
        return this.retry;
    }

    public void setRetry(Boolean retry) {
        this.retry = retry;
    }

    public boolean isHasStats() {
        return this.hasStats;
    }

    public void setHasStats(boolean hasStats) {
        this.hasStats = hasStats;
    }

    public String getLaunchUuid() {
        return this.launchUuid;
    }

    public void setLaunchUuid(String launchUuid) {
        this.launchUuid = launchUuid;
    }

    public List<ParameterResource> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<ParameterResource> parameters) {
        this.parameters = parameters;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getTestCaseId() {
        return this.testCaseId;
    }

    public void setTestCaseId(String testCaseId) {
        this.testCaseId = testCaseId;
    }

    public Integer getTestCaseHash() {
        return this.testCaseHash;
    }

    public void setTestCaseHash(Integer testCaseHash) {
        this.testCaseHash = testCaseHash;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        StartTestItemRQ that = (StartTestItemRQ)o;
        return this.hasStats == that.hasStats && Objects.equals(this.codeRef, that.codeRef) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.uniqueId, that.uniqueId) && Objects.equals(this.testCaseId, that.testCaseId) && Objects.equals(this.testCaseHash, that.testCaseHash) && Objects.equals(this.launchUuid, that.launchUuid) && Objects.equals(this.type, that.type) && Objects.equals(this.retry, that.retry);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.codeRef, this.parameters, this.uniqueId, this.testCaseId, this.testCaseHash, this.launchUuid, this.type, this.retry, this.hasStats);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("StartTestItemRQ{");
        sb.append("codeRef='").append(this.codeRef).append('\'');
        sb.append(", parameters=").append(this.parameters);
        sb.append(", uniqueId='").append(this.uniqueId).append('\'');
        sb.append(", testCaseId='").append(this.testCaseId).append('\'');
        sb.append(", testCaseHash='").append(this.testCaseHash).append('\'');
        sb.append(", launchUuid='").append(this.launchUuid).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append(", retry=").append(this.retry);
        sb.append(", hasStats=").append(this.hasStats);
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private static class UpperCaseTypeSerializer
    extends JsonSerializer<String> {
        private UpperCaseTypeSerializer() {
        }

        public void serialize(String type, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            if (type != null) {
                jsonGenerator.writeString(type.toUpperCase());
            }
        }
    }

    private static class UpperCaseTypeDeserializer
    extends JsonDeserializer<String> {
        private UpperCaseTypeDeserializer() {
        }

        public String deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            ObjectCodec oc = parser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(parser);
            return node.asText().toUpperCase();
        }
    }
}

