/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model.externalsystem;

import com.epam.ta.reportportal.ws.model.externalsystem.AllowedValue;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PostFormField
implements Comparable<PostFormField>,
Serializable {
    @JsonProperty(value="fieldName")
    private String fieldName;
    @JsonProperty(value="id", required=true)
    private String id;
    @JsonProperty(value="fieldType")
    private String fieldType;
    @JsonProperty(value="required", required=true)
    private boolean isRequired;
    @JsonProperty(value="value", required=true)
    private List<String> value;
    @JsonProperty(value="definedValues")
    private List<AllowedValue> definedValues;

    public PostFormField() {
    }

    public PostFormField(String id, String name, String type, boolean isReq, List<String> values, List<AllowedValue> defValues) {
        this.id = id;
        this.fieldName = name;
        this.fieldType = type;
        this.isRequired = isReq;
        this.value = values;
        this.definedValues = defValues;
    }

    public void setFieldName(String name) {
        this.fieldName = name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setId(String value) {
        this.id = value;
    }

    public String getId() {
        return this.id;
    }

    public void setFieldType(String type) {
        this.fieldType = type;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setIsRequired(boolean value) {
        this.isRequired = value;
    }

    public boolean getIsRequired() {
        return this.isRequired;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public List<String> getValue() {
        return this.value;
    }

    public List<AllowedValue> getDefinedValues() {
        return this.definedValues;
    }

    public void setDefinedValues(List<AllowedValue> values) {
        this.definedValues = values;
    }

    public String toString() {
        return "PostFormField{fieldName='" + this.fieldName + '\'' + ", id='" + this.id + '\'' + ", fieldType='" + this.fieldType + '\'' + ", isRequired=" + this.isRequired + ", value=" + this.value + ", definedValues=" + this.definedValues + '}';
    }

    @Override
    public int compareTo(PostFormField field) {
        Boolean current = this.isRequired;
        Boolean byField = field.isRequired;
        return byField.compareTo(current);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostFormField that = (PostFormField)o;
        if (this.isRequired != that.isRequired) {
            return false;
        }
        if (this.fieldName != null ? !this.fieldName.equals(that.fieldName) : that.fieldName != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        if (this.fieldType != null ? !this.fieldType.equals(that.fieldType) : that.fieldType != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.definedValues != null ? this.definedValues.equals(that.definedValues) : that.definedValues == null;
    }

    public int hashCode() {
        int result = this.fieldName != null ? this.fieldName.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.fieldType != null ? this.fieldType.hashCode() : 0);
        result = 31 * result + (this.isRequired ? 1 : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.definedValues != null ? this.definedValues.hashCode() : 0);
        return result;
    }
}

