/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.model;

public enum ErrorType {
    INCORRECT_REQUEST(4001, "Incorrect Request. {}"),
    BINARY_DATA_CANNOT_BE_SAVED(4002, "Binary data cannot be saved. {}"),
    ACCESS_DENIED(4003, "You do not have enough permissions. {}"),
    ADDRESS_LOCKED(4004, "Address is locked due to several incorrect login attempts"),
    PROJECT_NOT_FOUND(4040, "Project '{}' not found. Did you use correct project name?"),
    LAUNCH_NOT_FOUND(4041, "Launch '{}' not found. Did you use correct Launch ID?"),
    TEST_SUITE_NOT_FOUND(4042, "TestSuite Not Found. Did you use correct TestSuite ID?"),
    TEST_ITEM_NOT_FOUND(4043, "Test Item '{}' not found. Did you use correct Test Item ID?"),
    LOG_NOT_FOUND(4044, "Log '{}' not found. Did you use correct Log ID?"),
    ROLE_NOT_FOUND(4045, "Project role '{}' not found. Did you use correct Role Name?"),
    USER_NOT_FOUND(4046, "User '{}' not found. {}"),
    WIDGET_NOT_FOUND(4047, "Widget with ID '{}' not found. Did you use correct Widget ID?"),
    WIDGET_NOT_FOUND_IN_DASHBOARD(4048, "Widget with ID '{}' not found in dashboard '{}'. Did you use correct Widget ID?"),
    DASHBOARD_NOT_FOUND(4049, "Dashboard with ID '{}' not found. Did you use correct Dashboard ID?"),
    USER_FILTER_NOT_FOUND(40410, "User filter with ID '{}' is not found on project '{}' for user '{}'. Did you use correct User Filter ID?"),
    ACTIVITY_NOT_FOUND(40411, "Activity '{}' not found. Did you use correct Activity ID?"),
    UNABLE_TO_CREATE_WIDGET(40412, "Unable to create or update widget. {}"),
    INTEGRATION_NOT_FOUND(40413, "Integration with ID '{}' not found. Did you use correct ID?"),
    PROJECT_NOT_CONFIGURED(40414, "Project '{}' not configured."),
    SERVER_SETTINGS_NOT_FOUND(40415, "Server Settings with '{}' profile not found."),
    ISSUE_TYPE_NOT_FOUND(40416, "Issue Type '{}' not found."),
    PROJECT_SETTINGS_NOT_FOUND(40417, "Project Settings for project '{}' not found."),
    TICKET_NOT_FOUND(40418, "Ticket with ID '{}' not found. Did you use correct Ticket ID?"),
    AUTH_INTEGRATION_NOT_FOUND(40419, "Auth integration '{}' not found. Did you use correct name?"),
    WIDGET_NOT_FOUND_IN_PROJECT(40420, "Widget with ID '{}' not found on project '{}'. Did you use correct Widget ID?"),
    USER_FILTER_NOT_FOUND_IN_PROJECT(40421, "User filter with ID '{}' not found on project '{}'. Did you use correct User Filter ID?"),
    DASHBOARD_NOT_FOUND_IN_PROJECT(40422, "Dashboard with ID '{}' not found on project '{}'. Did you use correct Dashboard ID?"),
    PATTERN_TEMPLATE_NOT_FOUND_IN_PROJECT(40423, "Pattern template with ID '{}' not found on project '{}'. Did you use correct Pattern template ID?"),
    TEST_ITEM_OR_LAUNCH_NOT_FOUND(40424, "Test Item or Launch '{}' not found. Did you use correct ID?"),
    ANALYZER_NOT_FOUND(40425, "Analyzer '{}' not found."),
    ATTACHMENT_NOT_FOUND(40426, "Attachment '{}' not found"),
    UNABLE_TO_LOAD_BINARY_DATA(40427, "Unable to load binary data by id '{}'"),
    CLUSTER_NOT_FOUND(40428, "Cluster '{}' not found"),
    NOT_FOUND(40430, "'{}' not found. Did you use correct ID?"),
    INCORRECT_FILTER_PARAMETERS(40011, "Incorrect filtering parameters. {}"),
    INCORRECT_SORTING_PARAMETERS(40012, "Sorting parameter {} is not defined"),
    INCORRECT_INTEGRATION_NAME(40013, "Incorrect integration name. {}"),
    UNABLE_MODIFY_SHARABLE_RESOURCE(40014, "Unable modify sharable resource. {}"),
    INCORRECT_AUTHENTICATION_TYPE(40015, "Incorrect authentication type: {}"),
    UNABLE_POST_TICKET(40301, "Impossible post ticket. {}"),
    UNABLE_INTERACT_WITH_INTEGRATION(40302, "Impossible interact with integration. {}"),
    UNABLE_ASSIGN_UNASSIGN_USER_TO_PROJECT(40304, "Unable assign/unassign user to/from project. {}"),
    EMAIL_CONFIGURATION_IS_INCORRECT(40305, "Email server is not configured or configuration is incorrect. {}"),
    PROJECT_UPDATE_NOT_ALLOWED(4007, "Update/Delete of project with type {} is not allowed"),
    UNABLE_TO_UPDATE_YOURSELF_ROLE(4008, "Unable to update yourself role."),
    FORBIDDEN_OPERATION(40010, "Forbidden operation. {}"),
    RESOURCE_ALREADY_EXISTS(4091, "Resource '{}' already exists. You couldn't create the duplicate."),
    ROLE_ALREADY_EXISTS_ERROR(4093, "Role with specified settings already exists. You couldn't create the duplicate."),
    USER_ALREADY_EXISTS(4094, "User with '{}' already exists. You couldn't create the duplicate."),
    USER_FILTER_ALREADY_EXISTS(4098, "User filter with name '{}' already exists for user '{}' under the project '{}'. You couldn't create the duplicate."),
    PROJECT_ALREADY_EXISTS(4095, "Project '{}' already exists. You couldn't create the duplicate."),
    DASHBOARD_UPDATE_ERROR(4096, "Dashboard update request contains invalid data. {}"),
    UNABLE_LOAD_WIDGET_CONTENT(4097, "Unable to load widget content. Widget properties contain errors: {}"),
    UNABLE_ADD_TO_FAVORITE(4099, "Unable add resource to favorites. {}"),
    INTEGRATION_ALREADY_EXISTS(40910, "Integration '{}' already exists. You couldn't create the duplicate."),
    SERVER_SETTINGS_ALREADY_EXISTS(40911, "Server settings with '{}' profile already exists. You couldn't create the duplicate."),
    UNABLE_REMOVE_FROM_FAVORITE(4100, "Unable remove resource from favorites. {}"),
    LAUNCH_IS_NOT_FINISHED(4063, "Unable to perform operation for non-finished launch. {}"),
    TEST_ITEM_IS_NOT_FINISHED(4064, "Unable to perform operation for non-finished test item. {}"),
    INCORRECT_FINISH_STATUS(4065, "{}. Did you provide correct status in request?"),
    BAD_REQUEST_ERROR(40016, "Error in handled Request. Please, check specified parameters: '{}'"),
    BAD_SAVE_LOG_REQUEST(40017, "Error in Save Log Request. {}"),
    REPORTING_ITEM_ALREADY_FINISHED(40018, "Reporting for item {} already finished. Please, check item status."),
    AMBIGUOUS_TEST_ITEM_STATUS(40019, "Test item status is ambiguous. {}"),
    FAILED_TEST_ITEM_ISSUE_TYPE_DEFINITION(40020, "Test items issue type cannot be resolved. {}"),
    FINISH_TIME_EARLIER_THAN_START_TIME(40021, "Finish time '{}' is earlier than start time '{}' for resource with ID '{}'"),
    FINISH_ITEM_NOT_ALLOWED(40022, "Finish test item is not allowed. {}"),
    FINISH_LAUNCH_NOT_ALLOWED(40023, "Finish launch is not allowed. {}"),
    START_ITEM_NOT_ALLOWED(40024, "Start test item is not allowed. {}"),
    CHILD_START_TIME_EARLIER_THAN_PARENT(40025, "Start time of child ['{}'] item should be same or later than start time ['{}'] of the parent item/launch '{}'"),
    UNSUPPORTED_TEST_ITEM_TYPE(40026, "Test Item type {} is unsupported"),
    LOGGING_IS_NOT_ALLOWED(40027, "Logging is not allowed. {}"),
    BAD_SAVE_WIDGET_REQUEST(40028, "Incorrect create widget request. {}"),
    BAD_UPDATE_WIDGET_REQUEST(40029, "Incorrect update widget request. {}"),
    UNABLE_LOAD_TEST_ITEM_HISTORY(40030, "Unable to load test item history. {}"),
    BAD_SAVE_USER_FILTER_REQUEST(40031, "Bad save user filter request. {}"),
    RETRIES_HANDLER_ERROR(40036, "Incorrect retries processing. {}"),
    IMPORT_FILE_ERROR(40035, "Error while importing the file. '{}'"),
    PARSING_XML_ERROR(40037, "Error during parsing the xml file: '{}'"),
    OBJECT_RETRIEVAL_ERROR(40038, "Error during object retrieving: '{}'"),
    PLUGIN_UPLOAD_ERROR(40039, "Error during plugin uploading: '{}'"),
    PLUGIN_REMOVE_ERROR(40040, "Error during plugin removing: '{}'"),
    UNABLE_TO_SAVE_CHILD_ITEM_FOR_THE_RETRY(40041, "Item with id = '{}' is a retry and can not have children"),
    PATTERN_ANALYSIS_ERROR(40042, "Pattern analysis error. {}"),
    PROJECT_DOESNT_CONTAIN_USER(4220, "Project '{}' doesn't contain user '{}'"),
    UNCLASSIFIED_REPORT_PORTAL_ERROR(5001, "Unclassified Report Portal Error"),
    BAD_UPDATE_PREFERENCE_REQUEST(40032, "Incorrect update widget request {}"),
    UNSUPPORTED_MERGE_STRATEGY_TYPE(40033, "Merge Strategy type {} is unsupported"),
    DEMO_DATA_GENERATION_ERROR(40034, "Demo Data Generation error: {}"),
    UNCLASSIFIED_ERROR(5000, "Unclassified error");

    private final int code;
    private final String description;

    private ErrorType(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static ErrorType getByCode(int code) {
        for (ErrorType error : ErrorType.values()) {
            if (error.getCode() != code) continue;
            return error;
        }
        throw new IllegalArgumentException("Unable to find Error with code '" + code + "'");
    }
}

