/*
 * Copyright 2019 EPAM Systems
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.epam.ta.reportportal.ws.model.statistics;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Map;

@JsonInclude(Include.NON_NULL)
public class StatisticsResource {

	@JsonProperty(value = "executions")
	private Map<String, Integer> executions;

	@JsonProperty(value = "defects")
	private Map<String, Map<String, Integer>> defects;

	public Map<String, Integer> getExecutions() {
		return executions;
	}

	public void setExecutions(Map<String, Integer> executions) {
		this.executions = executions;
	}

	public Map<String, Map<String, Integer>> getDefects() {
		return defects;
	}

	public void setDefects(Map<String, Map<String, Integer>> defects) {
		this.defects = defects;
	}

	@Override
	public String toString() {
		final StringBuilder sb = new StringBuilder("Statistics{");
		sb.append("executions=").append(executions);
		sb.append(", defects=").append(defects);
		sb.append('}');
		return sb.toString();
	}
}