/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.annotations;

import com.epam.ta.reportportal.ws.annotations.WidgetLimitRange;
import com.epam.ta.reportportal.ws.model.SharableEntityRQ;
import com.epam.ta.reportportal.ws.model.widget.MaterializedWidgetType;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import java.util.Arrays;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class WidgetLimitRangeValidator
implements ConstraintValidator<WidgetLimitRange, SharableEntityRQ> {
    public boolean isValid(SharableEntityRQ value, ConstraintValidatorContext context) {
        if (value instanceof WidgetRQ) {
            WidgetRQ widgetRQ = (WidgetRQ)value;
            int limit = widgetRQ.getContentParameters().getItemsCount();
            if (Arrays.stream(MaterializedWidgetType.values()).anyMatch(it -> it.getType().equalsIgnoreCase(widgetRQ.getWidgetType()))) {
                return limit >= 1;
            }
            this.updateValidationMessage("Widget item limit size must be between 1 and 600", context);
            return limit >= 1 && limit <= 600;
        }
        return false;
    }

    public void updateValidationMessage(String message, ConstraintValidatorContext context) {
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(message).addConstraintViolation();
    }
}

